/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.model.MessageId;

public class AttachmentMetadata {
    private final AttachmentId attachmentId;
    private final ContentType type;
    private final long size;
    private final MessageId messageId;

    public static Builder builder() {
        return new Builder();
    }

    private AttachmentMetadata(AttachmentId attachmentId, ContentType type, long size, MessageId messageId) {
        this.attachmentId = attachmentId;
        this.type = type;
        this.size = size;
        this.messageId = messageId;
    }

    public AttachmentId getAttachmentId() {
        return this.attachmentId;
    }

    public ContentType getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttachmentMetadata) {
            AttachmentMetadata other = (AttachmentMetadata)obj;
            return Objects.equal(this.attachmentId, other.attachmentId) && Objects.equal(this.type, other.type) && Objects.equal(this.size, other.size) && Objects.equal(this.messageId, other.messageId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.attachmentId, this.type, this.size, this.messageId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("attachmentId", this.attachmentId).add("messageId", this.messageId).add("type", this.type).add("size", this.size).toString();
    }

    public static class Builder {
        private AttachmentId attachmentId;
        private Long size;
        private ContentType type;
        private MessageId messageId;

        public Builder messageId(MessageId messageId) {
            Preconditions.checkArgument(messageId != null);
            this.messageId = messageId;
            return this;
        }

        public Builder attachmentId(AttachmentId attachmentId) {
            Preconditions.checkArgument(attachmentId != null);
            this.attachmentId = attachmentId;
            return this;
        }

        public Builder type(ContentType type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = ContentType.of(type);
            return this;
        }

        public Builder size(long size) {
            Preconditions.checkArgument(size >= 0L, "'size' must be positive");
            this.size = size;
            return this;
        }

        public AttachmentMetadata build() {
            Preconditions.checkState(this.type != null, "'type' is mandatory");
            Preconditions.checkState(this.size != null, "'size' is mandatory");
            Preconditions.checkState(this.attachmentId != null, "'attachmentId' is mandatory");
            Preconditions.checkState(this.messageId != null, "'messageId' is mandatory");
            return new AttachmentMetadata(this.attachmentId, this.type, this.size, this.messageId);
        }
    }
}

