/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.ThreadTablePartitionKey;
import org.apache.james.mailbox.cassandra.table.CassandraMessageIds;
import org.apache.james.mailbox.cassandra.table.CassandraThreadLookupTable;
import org.apache.james.mailbox.cassandra.table.CassandraThreadTable;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.MimeMessageId;
import reactor.core.publisher.Mono;

public class CassandraThreadLookupDAO {
    private static final TypeCodec<Set<String>> SET_OF_STRINGS_CODEC = CodecRegistry.DEFAULT.codecFor((DataType)DataTypes.frozenSetOf((DataType)DataTypes.TEXT));
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insert;
    private final PreparedStatement select;
    private final PreparedStatement delete;

    @Inject
    public CassandraThreadLookupDAO(CqlSession session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insert = session.prepare(QueryBuilder.insertInto((String)"threadLookupTable").value(CassandraMessageIds.MESSAGE_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)).value(CassandraThreadTable.USERNAME, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraThreadTable.USERNAME)).value(CassandraThreadLookupTable.MIME_MESSAGE_IDS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraThreadLookupTable.MIME_MESSAGE_IDS)).build());
        this.select = session.prepare(((Select)QueryBuilder.selectFrom((String)"threadLookupTable").columns(new CqlIdentifier[]{CassandraThreadTable.USERNAME, CassandraThreadLookupTable.MIME_MESSAGE_IDS}).where((Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)))).build());
        this.delete = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"threadLookupTable").where((Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)))).build());
    }

    public Mono<Void> insert(MessageId messageId, Username username, Set<MimeMessageId> mimeMessageIds) {
        Set mimeMessageIdsString = (Set)mimeMessageIds.stream().map(MimeMessageId::getValue).collect(ImmutableSet.toImmutableSet());
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.insert.bind(new Object[0]).set(CassandraMessageIds.MESSAGE_ID, (Object)((CassandraMessageId)messageId).get(), TypeCodecs.TIMEUUID)).set(CassandraThreadTable.USERNAME, (Object)username.asString(), TypeCodecs.TEXT)).set(CassandraThreadLookupTable.MIME_MESSAGE_IDS, (Object)mimeMessageIdsString, SET_OF_STRINGS_CODEC));
    }

    public Mono<ThreadTablePartitionKey> selectOneRow(MessageId messageId) {
        return this.executor.executeSingleRow((Statement)this.select.bind(new Object[0]).set(CassandraMessageIds.MESSAGE_ID, (Object)((CassandraMessageId)messageId).get(), TypeCodecs.TIMEUUID)).map(this::readRow);
    }

    public Mono<Void> deleteOneRow(MessageId messageId) {
        return this.executor.executeVoid((Statement)this.delete.bind(new Object[0]).set(CassandraMessageIds.MESSAGE_ID, (Object)((CassandraMessageId)messageId).get(), TypeCodecs.TIMEUUID));
    }

    private ThreadTablePartitionKey readRow(Row row) {
        Set mimeMessageIds = (Set)((Set)row.get(CassandraThreadLookupTable.MIME_MESSAGE_IDS, SET_OF_STRINGS_CODEC)).stream().map(MimeMessageId::new).collect(ImmutableSet.toImmutableSet());
        return new ThreadTablePartitionKey(Username.of((String)row.getString(CassandraThreadTable.USERNAME)), mimeMessageIds);
    }
}

