/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.filtering.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregateId;

public class IncrementalRuleChange
implements Event {
    private final FilteringAggregateId aggregateId;
    private final EventId eventId;
    private final ImmutableList<Rule> rulesPrepended;
    private final ImmutableList<Rule> rulesPostpended;
    private final ImmutableSet<Rule.Id> rulesDeleted;
    private final ImmutableList<Rule> rulesUpdated;

    public static Optional<IncrementalRuleChange> ofDiff(FilteringAggregateId aggregateId, EventId eventId, List<Rule> before, List<Rule> after) {
        ImmutableSet idsBefore = (ImmutableSet)before.stream().map(Rule::getId).collect(ImmutableSet.toImmutableSet());
        ImmutableSet idsAfter = (ImmutableSet)after.stream().map(Rule::getId).collect(ImmutableSet.toImmutableSet());
        ImmutableMap beforeIndexed = (ImmutableMap)before.stream().collect(ImmutableMap.toImmutableMap(Rule::getId, rule -> rule));
        ImmutableMap afterIndexed = (ImmutableMap)after.stream().collect(ImmutableMap.toImmutableMap(Rule::getId, rule -> rule));
        ImmutableSet deleted = Sets.difference((Set)idsBefore, (Set)idsAfter).immutableCopy();
        ImmutableList commonElements = ImmutableList.copyOf((Collection)Sets.intersection((Set)idsBefore, (Set)idsAfter).immutableCopy());
        ImmutableList idsAfterList = idsAfter.asList();
        ImmutableList.Builder updatedRules = ImmutableList.builder();
        int prependedItems = 0;
        int postPendedItems = 0;
        boolean inPrepended = true;
        boolean inCommonSection = false;
        boolean inPostpended = false;
        int position = 0;
        while (position < idsAfter.size()) {
            Rule.Id id = (Rule.Id)idsAfterList.get(position);
            if (inPrepended) {
                if (commonElements.contains(id)) {
                    inPrepended = false;
                    inCommonSection = true;
                    continue;
                }
                ++prependedItems;
                ++position;
                continue;
            }
            if (inPostpended) {
                if (commonElements.contains(id)) {
                    return Optional.empty();
                }
                ++postPendedItems;
                ++position;
                continue;
            }
            if (inCommonSection) {
                if (!commonElements.contains(id)) {
                    inCommonSection = false;
                    inPostpended = true;
                    continue;
                }
                int positionInCommonElements = position - prependedItems;
                if (positionInCommonElements > commonElements.size()) {
                    return Optional.empty();
                }
                if (!((Rule.Id)commonElements.get(positionInCommonElements)).equals(id)) {
                    return Optional.empty();
                }
                if (!((Rule)beforeIndexed.get((Object)id)).equals(afterIndexed.get((Object)id))) {
                    updatedRules.add((Object)((Rule)afterIndexed.get((Object)id)));
                    ++position;
                    continue;
                }
                ++position;
                continue;
            }
            throw new RuntimeException("Unexpected status");
        }
        ImmutableList preprended = (ImmutableList)idsAfter.stream().limit(prependedItems).map(arg_0 -> ((ImmutableMap)afterIndexed).get(arg_0)).collect(ImmutableList.toImmutableList());
        ImmutableList postPended = ((ImmutableList)idsAfter.asList().reverse().stream().limit(postPendedItems).map(arg_0 -> ((ImmutableMap)afterIndexed).get(arg_0)).collect(ImmutableList.toImmutableList())).reverse();
        return Optional.of(new IncrementalRuleChange(aggregateId, eventId, (ImmutableList<Rule>)preprended, (ImmutableList<Rule>)postPended, (ImmutableSet<Rule.Id>)deleted, (ImmutableList<Rule>)updatedRules.build()));
    }

    public IncrementalRuleChange(FilteringAggregateId aggregateId, EventId eventId, ImmutableList<Rule> rulesPrepended, ImmutableList<Rule> rulesPostpended, ImmutableSet<Rule.Id> rulesDeleted, ImmutableList<Rule> rulesUpdated) {
        this.aggregateId = aggregateId;
        this.eventId = eventId;
        this.rulesPrepended = rulesPrepended;
        this.rulesPostpended = rulesPostpended;
        this.rulesDeleted = rulesDeleted;
        this.rulesUpdated = rulesUpdated;
    }

    public EventId eventId() {
        return this.eventId;
    }

    public AggregateId getAggregateId() {
        return this.aggregateId;
    }

    public ImmutableList<Rule> getRulesPrepended() {
        return this.rulesPrepended;
    }

    public ImmutableList<Rule> getRulesPostPended() {
        return this.rulesPostpended;
    }

    public ImmutableSet<Rule.Id> getRulesDeleted() {
        return this.rulesDeleted;
    }

    public ImmutableList<Rule> getRulesUpdated() {
        return this.rulesUpdated;
    }

    public ImmutableList<Rule> apply(ImmutableList<Rule> rules) {
        ImmutableMap indexedUpdates = (ImmutableMap)this.rulesUpdated.stream().collect(ImmutableMap.toImmutableMap(Rule::getId, rule -> rule));
        return ImmutableList.builder().addAll(this.rulesPrepended).addAll((Iterable)rules.stream().filter(rule -> !this.rulesDeleted.contains((Object)rule.getId())).map(rule -> Optional.ofNullable((Rule)indexedUpdates.get((Object)rule.getId())).orElse((Rule)rule)).collect(ImmutableList.toImmutableList())).addAll(this.rulesPostpended).build();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncrementalRuleChange that = (IncrementalRuleChange)o;
        return Objects.equals(this.aggregateId, that.aggregateId) && Objects.equals(this.eventId, that.eventId) && Objects.equals(this.rulesDeleted, that.rulesDeleted) && Objects.equals(this.rulesPrepended, that.rulesPrepended) && Objects.equals(this.rulesUpdated, that.rulesUpdated) && Objects.equals(this.rulesPostpended, that.rulesPostpended);
    }

    public final int hashCode() {
        return Objects.hash(this.aggregateId, this.eventId, this.rulesPrepended, this.rulesPostpended, this.rulesDeleted, this.rulesDeleted);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("aggregateId", (Object)this.aggregateId).add("eventId", (Object)this.eventId).add("rulesDeleted", this.rulesDeleted).add("rulesPrepended", this.rulesPrepended).add("rulesPostpended", this.rulesPostpended).add("rulesUpdated", this.rulesUpdated).toString();
    }
}

