/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.auto$;
import eu.timepit.refined.string;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.jmap.api.model.Identity;
import org.apache.james.jmap.api.model.IdentityId;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.json.MDNSerializer;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.EmailHeaderName$;
import org.apache.james.jmap.mail.EmailSetRequest;
import org.apache.james.jmap.mail.ErrorField;
import org.apache.james.jmap.mail.ExtensionFieldName;
import org.apache.james.jmap.mail.ExtensionFieldValue;
import org.apache.james.jmap.mail.FinalRecipientField;
import org.apache.james.jmap.mail.FinalRecipientField$;
import org.apache.james.jmap.mail.IdentityIdNotFoundException;
import org.apache.james.jmap.mail.IncludeOriginalMessageField;
import org.apache.james.jmap.mail.MDN$;
import org.apache.james.jmap.mail.MDNGatewayField;
import org.apache.james.jmap.mail.MDNId$;
import org.apache.james.jmap.mail.MDNSend$;
import org.apache.james.jmap.mail.MDNSendAlreadySentException;
import org.apache.james.jmap.mail.MDNSendCreateRequest;
import org.apache.james.jmap.mail.MDNSendCreateRequest$;
import org.apache.james.jmap.mail.MDNSendCreateResponse;
import org.apache.james.jmap.mail.MDNSendCreateSuccess;
import org.apache.james.jmap.mail.MDNSendCreationId;
import org.apache.james.jmap.mail.MDNSendForbiddenFromException;
import org.apache.james.jmap.mail.MDNSendNotFoundException;
import org.apache.james.jmap.mail.MDNSendRequest;
import org.apache.james.jmap.mail.MDNSendRequestInvalidException;
import org.apache.james.jmap.mail.MDNSendRequestInvalidException$;
import org.apache.james.jmap.mail.MDNSendResults;
import org.apache.james.jmap.mail.MDNSendResults$;
import org.apache.james.jmap.mail.OriginalMessageIdField;
import org.apache.james.jmap.mail.OriginalRecipientField;
import org.apache.james.jmap.mail.ReportUAField;
import org.apache.james.jmap.mail.ReportUAField$;
import org.apache.james.jmap.mail.SubjectField;
import org.apache.james.jmap.mail.TextBodyField;
import org.apache.james.jmap.mail.TextHeaderValue$;
import org.apache.james.jmap.method.EmailSetMethod;
import org.apache.james.jmap.method.EmailSubmissionSetMethod$;
import org.apache.james.jmap.method.IdentityResolver;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.routes.ProcessingContext;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mdn.MDN;
import org.apache.james.mdn.MDNReport;
import org.apache.james.mdn.fields.Disposition;
import org.apache.james.mdn.fields.Error;
import org.apache.james.mdn.fields.ExtensionField;
import org.apache.james.mdn.fields.FinalRecipient;
import org.apache.james.mdn.fields.OriginalRecipient;
import org.apache.james.mdn.fields.Text;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.field.AddressListFieldLenientImpl;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.server.core.MailImpl;
import org.apache.james.util.ReactorUtils;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsError;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonValidationError;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\rMf\u0001B\u0015+\u0001UB\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t+\u0002\u0011\t\u0011)A\u0005-\"A\u0011\u000e\u0001B\u0001B\u0003%!\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003r\u0011!!\bA!b\u0001\n\u0003)\b\u0002C=\u0001\u0005\u0003\u0005\u000b\u0011\u0002<\t\u0011i\u0004!Q1A\u0005\u0002mD\u0011\"a\u0002\u0001\u0005\u0003\u0005\u000b\u0011\u0002?\t\u0015\u0005%\u0001A!b\u0001\n\u0003\tY\u0001\u0003\u0006\u0002\u001a\u0001\u0011\t\u0011)A\u0005\u0003\u001bA!\"a\u0007\u0001\u0005\u000b\u0007I\u0011AA\u000f\u0011)\tY\u0003\u0001B\u0001B\u0003%\u0011q\u0004\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011%\ti\u0006\u0001b\u0001\n\u0003\ny\u0006\u0003\u0005\u0002\n\u0002\u0001\u000b\u0011BA1\u0011%\tY\t\u0001b\u0001\n\u0003\ni\t\u0003\u0005\u0002.\u0002\u0001\u000b\u0011BAH\u0011)Y\u0006\u00011AA\u0002\u0013\u0005\u0011q\u0016\u0005\f\u0003c\u0003\u0001\u0019!a\u0001\n\u0003\t\u0019\f\u0003\u0006\u0002@\u0002\u0001\r\u0011!Q!\n\u0019Dq!!1\u0001\t\u0003\t\u0019\rC\u0004\u0002F\u0002!\t!a1\t\u000f\u0005U\u0007\u0001\"\u0011\u0002X\"9!\u0011\u0002\u0001\u0005B\t-\u0001b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\b\u0005O\u0002A\u0011\u0002B5\u0011\u001d\u0011\u0019\n\u0001C\u0005\u0005+CqAa*\u0001\t\u0013\u0011I\u000bC\u0004\u0003D\u0002!IA!2\t\u000f\t]\u0007\u0001\"\u0003\u0003Z\"9!\u0011\u001f\u0001\u0005\n\tM\bbBB\u0001\u0001\u0011%11\u0001\u0005\b\u0007c\u0001A\u0011BB\u001a\u0011\u001d\u0019i\u0006\u0001C\u0005\u0007?Bqa!\u001a\u0001\t\u0013\u00199\u0007C\u0004\u0004|\u0001!Ia! \t\u000f\rE\u0005\u0001\"\u0003\u0004\u0014\"91q\u0013\u0001\u0005\n\re\u0005bBBP\u0001\u0011%1\u0011\u0015\u0005\b\u0007W\u0003A\u0011BBW\u00055iEIT*f]\u0012lU\r\u001e5pI*\u00111\u0006L\u0001\u0007[\u0016$\bn\u001c3\u000b\u00055r\u0013\u0001\u00026nCBT!a\f\u0019\u0002\u000b)\fW.Z:\u000b\u0005E\u0012\u0014AB1qC\u000eDWMC\u00014\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0007\u0010$\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\r\u0005s\u0017PU3g!\rid\bQ\u0007\u0002U%\u0011qH\u000b\u0002\u0019\u001b\u0016$\bn\u001c3SKF,\u0018N]5oO\u0006\u001b7m\\;oi&#\u0007CA!E\u001b\u0005\u0011%BA\"-\u0003\u0011i\u0017-\u001b7\n\u0005\u0015\u0013%AD'E\u001dN+g\u000e\u001a*fcV,7\u000f\u001e\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000b1!\u00199j\u0015\tYe&A\u0005mS\u001a,7-_2mK&\u0011Q\n\u0013\u0002\n'R\f'\u000f^1cY\u0016\f!b]3sS\u0006d\u0017N_3s!\t\u00016+D\u0001R\u0015\t\u0011F&\u0001\u0003kg>t\u0017B\u0001+R\u00055iEIT*fe&\fG.\u001b>fe\u0006\u0001R.Y5m#V,W/\u001a$bGR|'/\u001f\u0019\u0003/\u0002\u00042\u0001\u0017/_\u001b\u0005I&BA%[\u0015\tYf&A\u0003rk\u0016,X-\u0003\u0002^3\n\u0001R*Y5m#V,W/\u001a$bGR|'/\u001f\t\u0003?\u0002d\u0001\u0001B\u0005b\u0005\u0005\u0005\t\u0011!B\u0001E\n\u0019q\fJ\u0019\u0012\u0005\r4\u0007CA\u001ce\u0013\t)\u0007HA\u0004O_RD\u0017N\\4\u0011\u0005a;\u0017B\u00015Z\u0005%i\u0015-\u001b7Rk\u0016,X-\u0001\tnKN\u001c\u0018mZ3JI6\u000bg.Y4feB\u00111N\\\u0007\u0002Y*\u0011QNL\u0001\b[\u0006LGNY8y\u0013\tyGN\u0001\tNKN\u001c\u0018mZ3JI6\u000bg.Y4fe\u0006qQ-\\1jYN+G/T3uQ>$\u0007CA\u001fs\u0013\t\u0019(F\u0001\bF[\u0006LGnU3u\u001b\u0016$\bn\u001c3\u0002!%$WM\u001c;jif\u0014Vm]8mm\u0016\u0014X#\u0001<\u0011\u0005u:\u0018B\u0001=+\u0005AIE-\u001a8uSRL(+Z:pYZ,'/A\tjI\u0016tG/\u001b;z%\u0016\u001cx\u000e\u001c<fe\u0002\nQ\"\\3ue&\u001cg)Y2u_JLX#\u0001?\u0011\u0007u\f\u0019!D\u0001\u007f\u0015\tIuPC\u0002\u0002\u00029\nq!\\3ue&\u001c7/C\u0002\u0002\u0006y\u0014Q\"T3ue&\u001cg)Y2u_JL\u0018AD7fiJL7MR1di>\u0014\u0018\u0010I\u0001\u0010g\u0016\u001c8/[8o'V\u0004\b\u000f\\5feV\u0011\u0011Q\u0002\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111\u0003\u0017\u0002\rI|W\u000f^3t\u0013\u0011\t9\"!\u0005\u0003\u001fM+7o]5p]N+\b\u000f\u001d7jKJ\f\u0001c]3tg&|gnU;qa2LWM\u001d\u0011\u0002#M,7o]5p]R\u0013\u0018M\\:mCR|'/\u0006\u0002\u0002 A!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&1\nAaY8sK&!\u0011\u0011FA\u0012\u0005E\u0019Vm]:j_:$&/\u00198tY\u0006$xN]\u0001\u0013g\u0016\u001c8/[8o)J\fgn\u001d7bi>\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003c\t\u0019$!\u000e\u0002@\u0005\u0005\u00131IA#\u0003\u000f\nI\u0005\u0005\u0002>\u0001!)a*\u0004a\u0001\u001f\"1Q+\u0004a\u0001\u0003o\u0001D!!\u000f\u0002>A!\u0001\fXA\u001e!\ry\u0016Q\b\u0003\u000bC\u0006U\u0012\u0011!A\u0001\u0006\u0003\u0011\u0007\"B5\u000e\u0001\u0004Q\u0007\"\u00029\u000e\u0001\u0004\t\b\"\u0002;\u000e\u0001\u00041\b\"\u0002>\u000e\u0001\u0004a\bbBA\u0005\u001b\u0001\u0007\u0011Q\u0002\u0005\b\u00037i\u0001\u0019AA\u0010Q\ri\u0011Q\n\t\u0005\u0003\u001f\nI&\u0004\u0002\u0002R)!\u00111KA+\u0003\u0019IgN[3di*\u0011\u0011qK\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u00037\n\tF\u0001\u0004J]*,7\r^\u0001\u000b[\u0016$\bn\u001c3OC6,WCAA1!\u0011\t\u0019'a!\u000f\t\u0005\u0015\u0014q\u0010\b\u0005\u0003O\niH\u0004\u0003\u0002j\u0005md\u0002BA6\u0003srA!!\u001c\u0002x9!\u0011qNA;\u001b\t\t\tHC\u0002\u0002tQ\na\u0001\u0010:p_Rt\u0014\"A\u001a\n\u0005E\u0012\u0014BA\u00181\u0013\tic&C\u0002\u0002&1JA!!!\u0002$\u0005Q\u0011J\u001c<pG\u0006$\u0018n\u001c8\n\t\u0005\u0015\u0015q\u0011\u0002\u000b\u001b\u0016$\bn\u001c3OC6,'\u0002BAA\u0003G\t1\"\\3uQ>$g*Y7fA\u0005!\"/Z9vSJ,GmQ1qC\nLG.\u001b;jKN,\"!a$\u0011\r\u0005E\u0015\u0011TAP\u001d\u0011\t\u0019*!&\u0011\u0007\u0005=\u0004(C\u0002\u0002\u0018b\na\u0001\u0015:fI\u00164\u0017\u0002BAN\u0003;\u00131aU3u\u0015\r\t9\n\u000f\t\u0005\u0003C\u000b9K\u0004\u0003\u0002f\u0005\r\u0016\u0002BAS\u0003G\tAcQ1qC\nLG.\u001b;z\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018\u0002BAU\u0003W\u0013AcQ1qC\nLG.\u001b;z\u0013\u0012,g\u000e^5gS\u0016\u0014(\u0002BAS\u0003G\tQC]3rk&\u0014X\rZ\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001c\b%F\u0001g\u0003%\tX/Z;f?\u0012*\u0017\u000f\u0006\u0003\u00026\u0006m\u0006cA\u001c\u00028&\u0019\u0011\u0011\u0018\u001d\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003{\u001b\u0012\u0011!a\u0001M\u0006\u0019\u0001\u0010J\u0019\u0002\rE,X-^3!\u0003\u0011Ig.\u001b;\u0016\u0005\u0005U\u0016a\u00023jgB|7/\u001a\u0015\u0004-\u0005%\u0007\u0003BAf\u0003#l!!!4\u000b\t\u0005=\u0017QK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAj\u0003\u001b\u0014!\u0002\u0015:f\t\u0016\u001cHO]8z\u0003%!w\u000e\u0015:pG\u0016\u001c8\u000f\u0006\u0006\u0002Z\u0006M\u0018q_A~\u0005\u000b\u0001b!a7\u0002j\u00065XBAAo\u0015\u0011\ty.!9\u0002\u0013A,(\r\\5tQ\u0016\u0014(bA\u001d\u0002d*!\u0011QEAs\u0015\t\t9/A\u0004sK\u0006\u001cGo\u001c:\n\t\u0005-\u0018Q\u001c\u0002\u0006'\u001acW\u000f\u001f\t\u0004{\u0005=\u0018bAAyU\t)\u0012J\u001c<pG\u0006$\u0018n\u001c8XSRD7i\u001c8uKb$\bbBA{/\u0001\u0007\u0011qR\u0001\rG\u0006\u0004\u0018MY5mSRLWm\u001d\u0005\b\u0003s<\u0002\u0019AAw\u0003)IgN^8dCRLwN\u001c\u0005\b\u0003{<\u0002\u0019AA\u0000\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u00042a\u001bB\u0001\u0013\r\u0011\u0019\u0001\u001c\u0002\u000f\u001b\u0006LGNY8y'\u0016\u001c8/[8o\u0011\u0019\u00119a\u0006a\u0001\u0001\u00069!/Z9vKN$\u0018AC4fiJ+\u0017/^3tiR1!Q\u0002B\u0013\u0005O\u0001rAa\u0004\u0003\u001a\t}\u0001I\u0004\u0003\u0003\u0012\tUa\u0002BA8\u0005'I\u0011!O\u0005\u0004\u0005/A\u0014a\u00029bG.\fw-Z\u0005\u0005\u00057\u0011iB\u0001\u0004FSRDWM\u001d\u0006\u0004\u0005/A\u0004\u0003\u0002B\b\u0005CIAAa\t\u0003\u001e\tIQ\t_2faRLwN\u001c\u0005\b\u0003{D\u0002\u0019AA\u0000\u0011\u001d\tI\u0010\u0007a\u0001\u0005S\u0001B!!\t\u0003,%!!QFA\u0012\u0005)IeN^8dCRLwN\\\u0001\u0007GJ,\u0017\r^3\u0015\u0015\tM\"1\nB/\u0005?\u0012\u0019\u0007\u0005\u0004\u0002\\\nU\"\u0011H\u0005\u0005\u0005o\tiNA\u0003T\u001b>tw\u000eE\u00048\u0005w\u0011yD!\u0012\n\u0007\tu\u0002H\u0001\u0004UkBdWM\r\t\u0004\u0003\n\u0005\u0013b\u0001B\"\u0005\nqQ\n\u0012(TK:$'+Z:vYR\u001c\b\u0003BA\b\u0005\u000fJAA!\u0013\u0002\u0012\t\t\u0002K]8dKN\u001c\u0018N\\4D_:$X\r\u001f;\t\u000f\t5\u0013\u00041\u0001\u0003P\u0005A\u0011\u000eZ3oi&$\u0018\u0010\u0005\u0003\u0003R\teSB\u0001B*\u0015\u0011\u0011)Fa\u0016\u0002\u000b5|G-\u001a7\u000b\u0005%c\u0013\u0002\u0002B.\u0005'\u0012\u0001\"\u00133f]RLG/\u001f\u0005\u0007\u0005\u000fI\u0002\u0019\u0001!\t\u000f\t\u0005\u0014\u00041\u0001\u0002\u0000\u000691/Z:tS>t\u0007b\u0002B33\u0001\u0007!QI\u0001\u0012aJ|7-Z:tS:<7i\u001c8uKb$\u0018!D2sK\u0006$X-\u0014#O'\u0016tG\r\u0006\u0007\u0003:\t-$Q\u000eB8\u0005s\u0012\t\nC\u0004\u0003bi\u0001\r!a@\t\u000f\t5#\u00041\u0001\u0003P!9!\u0011\u000f\u000eA\u0002\tM\u0014!E7e]N+g\u000eZ\"sK\u0006$\u0018n\u001c8JIB\u0019\u0011I!\u001e\n\u0007\t]$IA\tN\t:\u001bVM\u001c3De\u0016\fG/[8o\u0013\u0012DqAa\u001f\u001b\u0001\u0004\u0011i(\u0001\u0005kg>\u0013'.Z2u!\u0011\u0011yH!$\u000e\u0005\t\u0005%b\u0001*\u0003\u0004*!!Q\u0011BD\u0003\u0011a\u0017NY:\u000b\u0007%\u0013II\u0003\u0002\u0003\f\u0006!\u0001\u000f\\1z\u0013\u0011\u0011yI!!\u0003\u0011)\u001bxJ\u00196fGRDqA!\u001a\u001b\u0001\u0004\u0011)%A\bqCJ\u001cX-\u0014#O%\u0016\fX/Z:u)\u0011\u00119J!*\u0011\u0011\t=!\u0011\u0004BM\u0005?\u00032!\u0011BN\u0013\r\u0011iJ\u0011\u0002\u001f\u001b\u0012s5+\u001a8e%\u0016\fX/Z:u\u0013:4\u0018\r\\5e\u000bb\u001cW\r\u001d;j_:\u00042!\u0011BQ\u0013\r\u0011\u0019K\u0011\u0002\u0015\u001b\u0012s5+\u001a8e\u0007J,\u0017\r^3SKF,Xm\u001d;\t\u000f\tm4\u00041\u0001\u0003~\u000591/\u001a8e\u001b\u0012sEC\u0003BV\u0005s\u0013YL!0\u0003@BA!q\u0002B\r\u0005[\u0013\u0019\f\u0005\u0003\u0003\u0010\t=\u0016\u0002\u0002BY\u0005;\u0011\u0011\u0002\u00165s_^\f'\r\\3\u0011\u0007\u0005\u0013),C\u0002\u00038\n\u0013A#\u0014#O'\u0016tGm\u0011:fCR,7+^2dKN\u001c\bb\u0002B19\u0001\u0007\u0011q \u0005\b\u0005\u001bb\u0002\u0019\u0001B(\u0011\u001d\u0011\t\b\ba\u0001\u0005gBqA!1\u001d\u0001\u0004\u0011y*\u0001\u0007sKF,Xm\u001d;F]R\u0014\u00180A\u0004f]F,X-^3\u0015\t\u0005U&q\u0019\u0005\u0007\u0007v\u0001\rA!3\u0011\t\t-'1[\u0007\u0003\u0005\u001bTA!!\n\u0003P*\u0019!\u0011\u001b\u0018\u0002\rM,'O^3s\u0013\u0011\u0011)N!4\u0003\u00115\u000b\u0017\u000e\\%na2\fAD]3ue&,g/\u001a*fY\u0006$X\rZ'fgN\fw-\u001a*fgVdG\u000f\u0006\u0004\u0003\\\n5(q\u001e\t\t\u0005\u001f\u0011IB!8\u0003dB\u0019\u0011Ia8\n\u0007\t\u0005(I\u0001\rN\t:\u001bVM\u001c3O_R4u.\u001e8e\u000bb\u001cW\r\u001d;j_:\u0004BA!:\u0003j6\u0011!q\u001d\u0006\u0004\u0005+b\u0017\u0002\u0002Bv\u0005O\u0014Q\"T3tg\u0006<WMU3tk2$\bb\u0002B1=\u0001\u0007\u0011q \u0005\b\u0005\u0003t\u0002\u0019\u0001BP\u0003e1\u0018\r\\5eCR,W\n\u0012(O_R\fEN]3bIf\u001cVM\u001c;\u0015\t\tU(Q \t\t\u0005\u001f\u0011IBa>\u0003dB\u0019\u0011I!?\n\u0007\tm(IA\u000eN\t:\u001bVM\u001c3BYJ,\u0017\rZ=TK:$X\t_2faRLwN\u001c\u0005\b\u0005\u007f|\u0002\u0019\u0001Br\u0003Q\u0011X\r\\1uK\u0012lUm]:bO\u0016\u0014Vm];mi\u0006!\"-^5mI6\u000b\u0017\u000e\\!oIJ+7\u000f]8og\u0016$\"b!\u0002\u0004\u0010\rE11DB\u000f!!\u0011yA!\u0007\u0003.\u000e\u001d\u0001cB\u001c\u0003<\t%7\u0011\u0002\t\u0004\u0003\u000e-\u0011bAB\u0007\u0005\n)R\n\u0012(TK:$7I]3bi\u0016\u0014Vm\u001d9p]N,\u0007b\u0002B'A\u0001\u0007!q\n\u0005\b\u0007'\u0001\u0003\u0019AB\u000b\u0003\u0019\u0019XM\u001c3feB!\u0011\u0011SB\f\u0013\u0011\u0019I\"!(\u0003\rM#(/\u001b8h\u0011\u001d\u0011\t\r\ta\u0001\u0005?Cqaa\b!\u0001\u0004\u0019\t#A\bpe&<\u0017N\\1m\u001b\u0016\u001c8/Y4f!\u0011\u0019\u0019c!\f\u000e\u0005\r\u0015\"\u0002BB\u0014\u0007S\t1\u0001Z8n\u0015\r\u0019YCL\u0001\u0007[&lW\r\u000e6\n\t\r=2Q\u0005\u0002\b\u001b\u0016\u001c8/Y4f\u0003]\u0011W/\u001b7e\u001b\u0006LG.\u00118e\u001b&lW-T3tg\u0006<W\r\u0006\u0006\u00046\r\u00153qIB&\u0007\u001f\u0002ra\u000eB\u001e\u0005\u0013\u001c9\u0004\u0005\u0003\u0004:\r\u0005SBAB\u001e\u0015\u0011\u0019ida\u0010\u0002\u0011%tG/\u001a:oKRT1aQA+\u0013\u0011\u0019\u0019ea\u000f\u0003\u00175KW.Z'fgN\fw-\u001a\u0005\b\u0007'\t\u0003\u0019AB\u000b\u0011\u001d\u0019I%\ta\u0001\u0007+\t\u0011B]3dSBLWM\u001c;\t\u000f\r5\u0013\u00051\u0001\u0004\u0016\u000591/\u001e2kK\u000e$\bbBB)C\u0001\u000711K\u0001\u0004[\u0012t\u0007\u0003BB+\u00073j!aa\u0016\u000b\u0007\rEc&\u0003\u0003\u0004\\\r]#aA'E\u001d\u0006\u0001r-\u001a;NC&d'+Z2ja&,g\u000e\u001e\u000b\u0005\u0007C\u001a\u0019\u0007\u0005\u0005\u0003\u0010\te!Q\\B\u000b\u0011\u001d\u0019yB\ta\u0001\u0007C\tAcZ3u\u001b\u0012se)\u001b8bYJ+7-\u001b9jK:$HCBB5\u0007o\u001aI\b\u0005\u0005\u0003\u0010\te!QVB6!\u0011\u0019iga\u001d\u000e\u0005\r=$\u0002BB9\u0007/\naAZ5fY\u0012\u001c\u0018\u0002BB;\u0007_\u0012aBR5oC2\u0014VmY5qS\u0016tG\u000fC\u0004\u0003B\u000e\u0002\rAa(\t\u000f\t53\u00051\u0001\u0003P\u0005A!-^5mI6#e\n\u0006\u0006\u0004T\r}4\u0011QBB\u0007\u000fCqA!1%\u0001\u0004\u0011y\nC\u0004\u0004 \u0011\u0002\ra!\t\t\u000f\r\u0015E\u00051\u0001\u0004l\u0005qa-\u001b8bYJ+7-\u001b9jK:$\bbBBEI\u0001\u000711R\u0001\u0012_JLw-\u001b8bYJ+7-\u001b9jK:$\b\u0003BB7\u0007\u001bKAaa$\u0004p\t\trJ]5hS:\fGNU3dSBLWM\u001c;\u00023\t,\u0018\u000e\u001c3N\t:CU/\\1o%\u0016\fG-\u00192mKR+\u0007\u0010\u001e\u000b\u0005\u0007+\u0019)\nC\u0004\u0003B\u0016\u0002\rAa(\u0002'\t,\u0018\u000e\u001c3NKN\u001c\u0018mZ3Tk\nTWm\u0019;\u0015\r\rU11TBO\u0011\u001d\u0011\tM\na\u0001\u0005?Cqaa\b'\u0001\u0004\u0019\t#\u0001\u000eck&dG-\u0014#O'\u0016tGm\u0011:fCR,'+Z:q_:\u001cX\r\u0006\u0005\u0004\n\r\r6QUBT\u0011\u001d\u0011\tm\na\u0001\u0005?Cqa!\u0015(\u0001\u0004\u0019\u0019\u0006C\u0004\u0004*\u001e\u0002\raa\u000e\u0002\u00175LW.Z'fgN\fw-Z\u0001\u000fa\u0006\u00148/Z!t\u001b\u0016\u001c8/Y4f)\u0011\u0019\tca,\t\u000f\rE\u0006\u00061\u0001\u0003d\u0006qQ.Z:tC\u001e,'+\u001a7bi\u0016$\u0007")
public class MDNSendMethod
implements MethodRequiringAccountId<MDNSendRequest>,
Startable {
    private final MDNSerializer serializer;
    private final MailQueueFactory<? extends MailQueue> mailQueueFactory;
    private final MessageIdManager messageIdManager;
    private final EmailSetMethod emailSetMethod;
    private final IdentityResolver identityResolver;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;
    private final SessionTranslator sessionTranslator;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private MailQueue queue;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    public IdentityResolver identityResolver() {
        return this.identityResolver;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public MailQueue queue() {
        return this.queue;
    }

    public void queue_$eq(MailQueue x$1) {
        this.queue = x$1;
    }

    public void init() {
        this.queue_$eq(this.mailQueueFactory.createQueue(MailQueueFactory.SPOOL));
    }

    @PreDestroy
    public void dispose() {
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.queue().close()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 e, Function1<A1, B1> function1) {
                A1 A1 = e;
                EmailSubmissionSetMethod$.MODULE$.LOGGER().debug("error closing queue", e);
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Throwable e) {
                Throwable throwable = e;
                return true;
            }
        });
    }

    public SFlux<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, MDNSendRequest request) {
        return ((SMono)request.identityId().validate().fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)new IllegalArgumentException("The IdentityId cannot be found", (Throwable)e)), (Function1 & Serializable)id -> this.identityResolver().resolveIdentityId((IdentityId)id, mailboxSession))).flatMap((Function1 & Serializable)maybeIdentity -> (SMono)maybeIdentity.map((Function1 & Serializable)identity -> this.create((Identity)identity, request, mailboxSession, invocation.processingContext())).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.error((Throwable)new IdentityIdNotFoundException("The IdentityId cannot be found")))).flatMapMany((Function1 & Serializable)createdResults -> {
            InvocationWithContext explicitInvocation = new InvocationWithContext(new Invocation(invocation.invocation().methodName(), (JsObject)$this.serializer.serializeMDNSendResponse(((MDNSendResults)createdResults._1()).asResponse(request.accountId())).as((Reads)Reads$.MODULE$.JsObjectReads()), invocation.invocation().methodCallId()), (ProcessingContext)createdResults._2());
            SMono emailSetCall = (SMono)request.implicitEmailSetRequest((Function1<MDNSendCreationId, Either<IllegalArgumentException, Option<MessageId>>>)(Function1 & Serializable)sendId -> ((MDNSendResults)createdResults._1()).resolveMessageId((MDNSendCreationId)sendId)).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)maybeEmailSetRequest -> (SMono)maybeEmailSetRequest.map((Function1 & Serializable)emailSetRequest -> $this.emailSetMethod.doProcess(capabilities, invocation, mailboxSession, (EmailSetRequest)emailSetRequest)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty()));
            return SFlux$.MODULE$.concat((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Publisher[]{SMono$.MODULE$.just((Object)explicitInvocation), emailSetCall}));
        });
    }

    @Override
    public Either<Exception, MDNSendRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        return this.serializer.deserializeMDNSendRequest((JsValue)invocation.arguments()).asEither().left().map((Function1 & Serializable)errors -> ResponseSerializer$.MODULE$.asException((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)errors)).flatMap((Function1 & Serializable)x$2 -> x$2.validate());
    }

    private SMono<Tuple2<MDNSendResults, ProcessingContext>> create(Identity identity, MDNSendRequest request, MailboxSession session, ProcessingContext processingContext) {
        return SFlux$.MODULE$.fromIterable((Iterable)request.send().view()).fold((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MDNSendResults$.MODULE$.empty()), (Object)processingContext), (Function2 & Serializable)(acc, elem) -> {
            Tuple2 tuple2 = elem;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MDNSendCreationId mdnSendId = (MDNSendCreationId)tuple2._1();
            JsObject jsObject = (JsObject)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mdnSendId, (Object)jsObject);
            MDNSendCreationId mdnSendId2 = (MDNSendCreationId)tuple22._1();
            JsObject jsObject2 = (JsObject)tuple22._2();
            Tuple2<MDNSendResults, ProcessingContext> tuple23 = this.createMDNSend(session, identity, mdnSendId2, jsObject2, (ProcessingContext)acc._2());
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            MDNSendResults creationResult = (MDNSendResults)tuple23._1();
            ProcessingContext updatedProcessingContext = (ProcessingContext)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)creationResult, (Object)updatedProcessingContext);
            MDNSendResults creationResult2 = (MDNSendResults)tuple24._1();
            ProcessingContext updatedProcessingContext2 = (ProcessingContext)tuple24._2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MDNSendResults$.MODULE$.merge((MDNSendResults)acc._1(), creationResult2)), (Object)updatedProcessingContext2);
        }).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    private Tuple2<MDNSendResults, ProcessingContext> createMDNSend(MailboxSession session, Identity identity, MDNSendCreationId mdnSendCreationId, JsObject jsObject, ProcessingContext processingContext) {
        return (Tuple2)this.parseMDNRequest(jsObject).flatMap((Function1 & Serializable)createRequest -> this.sendMDN(session, identity, mdnSendCreationId, (MDNSendCreateRequest)createRequest)).fold((Function1 & Serializable)error -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MDNSendResults$.MODULE$.notSent(mdnSendCreationId, (Throwable)error)), (Object)processingContext), (Function1 & Serializable)creation -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MDNSendResults$.MODULE$.sent((MDNSendCreateSuccess)creation)), (Object)processingContext));
    }

    private Either<MDNSendRequestInvalidException, MDNSendCreateRequest> parseMDNRequest(JsObject jsObject) {
        return MDNSendCreateRequest$.MODULE$.validateProperties(jsObject).flatMap((Function1 & Serializable)validJson -> {
            JsResult<MDNSendCreateRequest> jsResult = $this.serializer.deserializeMDNSendCreateRequest((JsValue)validJson);
            if (jsResult instanceof JsSuccess) {
                JsSuccess jsSuccess = (JsSuccess)jsResult;
                MDNSendCreateRequest createRequest = (MDNSendCreateRequest)jsSuccess.value();
                return createRequest.validate();
            }
            if (jsResult instanceof JsError) {
                JsError jsError = (JsError)jsResult;
                Seq errors = jsError.errors();
                return package$.MODULE$.Left().apply((Object)MDNSendRequestInvalidException$.MODULE$.parse((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)errors));
            }
            throw new MatchError(jsResult);
        });
    }

    private Either<Throwable, MDNSendCreateSuccess> sendMDN(MailboxSession session, Identity identity, MDNSendCreationId mdnSendCreationId, MDNSendCreateRequest requestEntry) {
        return this.retrieveRelatedMessageResult(session, requestEntry).flatMap((Function1 & Serializable)mdnRelatedMessageResult -> this.validateMDNNotAlreadySent((MessageResult)mdnRelatedMessageResult).map((Function1 & Serializable)mdnRelatedMessageResultAlready -> {
            Message messageRelated = this.parseAsMessage((MessageResult)mdnRelatedMessageResultAlready);
            return new Tuple2(mdnRelatedMessageResultAlready, (Object)messageRelated);
        }).flatMap((Function1 & Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 != null) {
                MessageResult mdnRelatedMessageResultAlready = (MessageResult)tuple2._1();
                Message messageRelated = (Message)tuple2._2();
                return this.buildMailAndResponse(identity, session.getUser().asString(), requestEntry, messageRelated).flatMap((Function1 & Serializable)mailAndResponseAndId -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.enqueue((MailImpl)mailAndResponseAndId._1())).toEither().map((Function1 & Serializable)x$5 -> {
                    BoxedUnit boxedUnit = x$5;
                    return new MDNSendCreateSuccess(mdnSendCreationId, (MDNSendCreateResponse)mailAndResponseAndId._2(), mdnRelatedMessageResultAlready.getMessageId());
                }));
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private void enqueue(MailImpl mail) {
        try {
            this.queue().enQueue((Mail)mail);
        }
        finally {
            LifecycleUtil.dispose((Object)mail);
        }
    }

    private Either<MDNSendNotFoundException, MessageResult> retrieveRelatedMessageResult(MailboxSession session, MDNSendCreateRequest requestEntry) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.messageIdManager.getMessage(requestEntry.forEmailId(), FetchGroup.FULL_CONTENT, session)).asScala().toList().headOption().toRight((Function0 & Serializable)() -> new MDNSendNotFoundException("The reference \"forEmailId\" cannot be found."));
    }

    private Either<MDNSendAlreadySentException, MessageResult> validateMDNNotAlreadySent(MessageResult relatedMessageResult) {
        if (relatedMessageResult.getFlags().contains(MDNSend$.MODULE$.MDN_ALREADY_SENT_FLAG())) {
            return package$.MODULE$.Left().apply((Object)new MDNSendAlreadySentException());
        }
        return package$.MODULE$.Right().apply((Object)relatedMessageResult);
    }

    private Either<Throwable, Tuple2<MailImpl, MDNSendCreateResponse>> buildMailAndResponse(Identity identity, String sender, MDNSendCreateRequest requestEntry, Message originalMessage) {
        return this.getMailRecipient(originalMessage).flatMap((Function1 & Serializable)mailRecipient -> this.getMDNFinalRecipient(requestEntry, identity).map((Function1 & Serializable)mdnFinalRecipient -> {
            OriginalRecipient mdnOriginalRecipient = OriginalRecipient.builder().originalRecipient(Text.fromRawText((String)sender)).build();
            MDN mdn = this.buildMDN(requestEntry, originalMessage, (FinalRecipient)mdnFinalRecipient, mdnOriginalRecipient);
            String subject = this.buildMessageSubject(requestEntry, originalMessage);
            Tuple2<MailImpl, MimeMessage> tuple2 = this.buildMailAndMimeMessage(sender, (String)mailRecipient, subject, mdn);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            MailImpl mailImpl = (MailImpl)tuple2._1();
            MimeMessage mimeMessage = (MimeMessage)tuple2._2();
            Tuple3 tuple3 = new Tuple3(tuple2, (Object)mailImpl, (Object)mimeMessage);
            Tuple2 x$7 = (Tuple2)tuple3._1();
            MailImpl mailImpl2 = (MailImpl)tuple3._2();
            MimeMessage mimeMessage2 = (MimeMessage)tuple3._3();
            return new Tuple5(mdnFinalRecipient, (Object)mdnOriginalRecipient, (Object)mdn, (Object)subject, (Object)x$7);
        }).map((Function1 & Serializable)x$9 -> {
            Tuple5 tuple5 = x$9;
            if (tuple5 != null) {
                MDN mdn = (MDN)tuple5._3();
                Tuple2 tuple2 = (Tuple2)tuple5._5();
                if (tuple2 != null) {
                    MailImpl mailImpl = (MailImpl)tuple2._1();
                    MimeMessage mimeMessage = (MimeMessage)tuple2._2();
                    return new Tuple2((Object)mailImpl, (Object)this.buildMDNSendCreateResponse(requestEntry, mdn, mimeMessage));
                }
            }
            throw new MatchError((Object)tuple5);
        }));
    }

    private Tuple2<MailImpl, MimeMessage> buildMailAndMimeMessage(String sender, String recipient, String subject, MDN mdn) {
        MimeMessage mimeMessage = mdn.asMimeMessage();
        mimeMessage.setFrom(sender);
        mimeMessage.setRecipients(Message.RecipientType.TO, recipient);
        mimeMessage.setSubject(subject);
        mimeMessage.saveChanges();
        MailImpl mailImpl = MailImpl.builder().name((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)MDNId$.MODULE$.generate().value()), RefType$.MODULE$.refinedRefType())).sender(sender).addRecipient(recipient).mimeMessage(mimeMessage).build();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mailImpl), (Object)mimeMessage);
    }

    private Either<MDNSendNotFoundException, String> getMailRecipient(Message originalMessage) {
        return CollectionConverters$.MODULE$.ListHasAsScala(originalMessage.getHeader().getFields(MDN$.MODULE$.DISPOSITION_NOTIFICATION_TO())).asScala().headOption().map((Function1 & Serializable)field -> (AddressListField)AddressListFieldLenientImpl.PARSER.parse(field, new DecodeMonitor())).map((Function1 & Serializable)addressListField -> addressListField.getAddressList()).map((Function1 & Serializable)addressList -> addressList.flatten()).flatMap((Function1 & Serializable)mailboxList -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mailboxList.stream().findAny()))).map((Function1 & Serializable)mailbox -> mailbox.getAddress()).toRight((Function0 & Serializable)() -> new MDNSendNotFoundException("Invalid \"Disposition-Notification-To\" header field."));
    }

    private Either<Throwable, FinalRecipient> getMDNFinalRecipient(MDNSendCreateRequest requestEntry, Identity identity) {
        return (Either)requestEntry.finalRecipient().map((Function1 & Serializable)finalRecipient -> MDNSendMethod.$anonfun$getMDNFinalRecipient$1(((FinalRecipientField)finalRecipient).value())).map((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            Right right = null;
            Either either = x0$1;
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                MailAddress mailAddress = (MailAddress)right.value();
                if (mailAddress.equals((Object)identity.email())) {
                    return package$.MODULE$.Right().apply(FinalRecipientField$.MODULE$.asJava$extension(((FinalRecipientField)requestEntry.finalRecipient().get()).value()).get());
                }
            }
            if (bl) {
                return package$.MODULE$.Left().apply((Object)new MDNSendForbiddenFromException("The user is not allowed to use the given \"finalRecipient\" property"));
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable error = (Throwable)left.value();
                return package$.MODULE$.Left().apply((Object)error);
            }
            throw new MatchError((Object)either);
        }).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Right().apply((Object)FinalRecipient.builder().finalRecipient(Text.fromRawText((String)identity.email().asString())).build()));
    }

    private MDN buildMDN(MDNSendCreateRequest requestEntry, Message originalMessage, FinalRecipient finalRecipient, OriginalRecipient originalRecipient) {
        MDNReport.Builder reportBuilder = MDNReport.builder().dispositionField((Disposition)requestEntry.disposition().asJava().get()).finalRecipientField(finalRecipient).originalRecipientField(originalRecipient);
        CollectionConverters$.MODULE$.ListHasAsScala(originalMessage.getHeader().getFields("Message-ID")).asScala().map((Function1 & Serializable)field -> reportBuilder.originalMessageIdField(field.getBody()));
        requestEntry.reportingUA().map((Function1 & Serializable)uaField -> MDNSendMethod.$anonfun$buildMDN$2(reportBuilder, ((ReportUAField)uaField).value()));
        requestEntry.extensionFields().map((Function1 & Serializable)extensions -> (scala.collection.immutable.Iterable)extensions.map((Function1 & Serializable)extension2 -> reportBuilder.withExtensionField(ExtensionField.builder().fieldName(((ExtensionFieldName)extension2._1()).value()).rawValue(((ExtensionFieldValue)extension2._2()).value()).build())));
        CollectionConverters$.MODULE$.ListHasAsScala(originalMessage.getHeader().getFields(EmailHeaderName$.MODULE$.MESSAGE_ID())).asScala().headOption().map((Function1 & Serializable)messageIdHeader -> reportBuilder.originalMessageIdField(TextHeaderValue$.MODULE$.from((Field)messageIdHeader).value()));
        return MDN.builder().report(reportBuilder.build()).humanReadableText(this.buildMDNHumanReadableText(requestEntry)).message(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(requestEntry.includeOriginalMessage().filter((Function1 & Serializable)isInclude -> BoxesRunTime.boxToBoolean((boolean)((IncludeOriginalMessageField)isInclude).value())).map((Function1 & Serializable)x$10 -> originalMessage)))).build();
    }

    private String buildMDNHumanReadableText(MDNSendCreateRequest requestEntry) {
        return (String)requestEntry.textBody().map((Function1 & Serializable)textBody -> ((TextBodyField)textBody).value()).getOrElse((Function0 & Serializable)() -> new StringBuilder(48).append("The email has been ").append(requestEntry.disposition().type()).append(" on your recipient's computer").toString());
    }

    private String buildMessageSubject(MDNSendCreateRequest requestEntry, Message originalMessage) {
        return (String)requestEntry.subject().map((Function1 & Serializable)subject -> ((SubjectField)subject).value()).getOrElse((Function0 & Serializable)() -> new StringBuilder(11).append("[Received] ").append(originalMessage.getSubject()).toString());
    }

    private MDNSendCreateResponse buildMDNSendCreateResponse(MDNSendCreateRequest requestEntry, MDN mdn, MimeMessage mimeMessage) {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        None$ none$5;
        Option<SubjectField> option = requestEntry.subject();
        if (option instanceof Some) {
            none$5 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option)) {
            none$5 = new Some((Object)new SubjectField(mimeMessage.getSubject()));
        } else {
            throw new MatchError(option);
        }
        None$ x$1 = none$5;
        Option<TextBodyField> option2 = requestEntry.textBody();
        if (option2 instanceof Some) {
            none$4 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option2)) {
            none$4 = new Some((Object)new TextBodyField(mdn.getHumanReadableText()));
        } else {
            throw new MatchError(option2);
        }
        None$ x$2 = none$4;
        Option<ReportUAField> option3 = requestEntry.reportingUA();
        if (option3 instanceof Some) {
            none$3 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option3)) {
            none$3 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getReportingUserAgentField().map(ua -> new ReportUAField(ua.fieldValue()))));
        } else {
            throw new MatchError(option3);
        }
        None$ x$3 = none$3;
        Option x$4 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getGatewayField().map(gateway -> new MDNGatewayField(gateway.fieldValue()))));
        Option x$5 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getOriginalRecipientField().map(originalRecipient -> new OriginalRecipientField(originalRecipient.fieldValue()))));
        Option<IncludeOriginalMessageField> option4 = requestEntry.includeOriginalMessage();
        if (option4 instanceof Some) {
            none$2 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option4)) {
            none$2 = new Some((Object)new IncludeOriginalMessageField(mdn.getOriginalMessage().isPresent()));
        } else {
            throw new MatchError(option4);
        }
        None$ x$6 = none$2;
        Option x$7 = Option$.MODULE$.apply((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mdn.getReport().getErrorFields()).asScala().map((Function1 & Serializable)error -> new ErrorField(MDNSendMethod.$anonfun$buildMDNSendCreateResponse$4(error)))).toSeq()).filter((Function1 & Serializable)error -> BoxesRunTime.boxToBoolean((boolean)error.nonEmpty()));
        Option<FinalRecipientField> option5 = requestEntry.finalRecipient();
        if (option5 instanceof Some) {
            none$ = None$.MODULE$;
        } else if (None$.MODULE$.equals(option5)) {
            none$ = new Some((Object)new FinalRecipientField(mdn.getReport().getFinalRecipientField().fieldValue()));
        } else {
            throw new MatchError(option5);
        }
        None$ x$8 = none$;
        Option x$9 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getOriginalMessageIdField().map(originalMessageId -> new OriginalMessageIdField(originalMessageId.getOriginalMessageId()))));
        return new MDNSendCreateResponse((Option<SubjectField>)x$1, (Option<TextBodyField>)x$2, (Option<ReportUAField>)x$3, (Option<MDNGatewayField>)x$4, (Option<OriginalRecipientField>)x$5, (Option<FinalRecipientField>)x$8, (Option<IncludeOriginalMessageField>)x$6, (Option<OriginalMessageIdField>)x$9, (Option<scala.collection.immutable.Seq<ErrorField>>)x$7);
    }

    private Message parseAsMessage(MessageResult messageRelated) {
        DefaultMessageBuilder messageBuilder = new DefaultMessageBuilder();
        messageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        messageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        return messageBuilder.parseMessage(messageRelated.getFullContent().getInputStream());
    }

    public static final /* synthetic */ Either $anonfun$getMDNFinalRecipient$1(String finalRecipient) {
        return FinalRecipientField$.MODULE$.getMailAddress$extension(finalRecipient).toEither();
    }

    public static final /* synthetic */ Try $anonfun$buildMDN$2(MDNReport.Builder reportBuilder$1, String uaField) {
        return ReportUAField$.MODULE$.asJava$extension(uaField).map((Function1 & Serializable)reportingUserAgent -> reportBuilder$1.reportingUserAgentField(reportingUserAgent));
    }

    public static final /* synthetic */ String $anonfun$buildMDNSendCreateResponse$4(Error error) {
        return error.getText().formatted();
    }

    @Inject
    public MDNSendMethod(MDNSerializer serializer, MailQueueFactory<? extends MailQueue> mailQueueFactory, MessageIdManager messageIdManager, EmailSetMethod emailSetMethod, IdentityResolver identityResolver, MetricFactory metricFactory, SessionSupplier sessionSupplier, SessionTranslator sessionTranslator) {
        this.serializer = serializer;
        this.mailQueueFactory = mailQueueFactory;
        this.messageIdManager = messageIdManager;
        this.emailSetMethod = emailSetMethod;
        this.identityResolver = identityResolver;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
        this.sessionTranslator = sessionTranslator;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"MDN/send")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MDN()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MAIL()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE())}));
        Statics.releaseFence();
    }
}

