/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import com.google.common.base.Preconditions;
import org.apache.james.mailbox.model.MessageRange;

public class MessageUid
implements Comparable<MessageUid> {
    public static final MessageUid MAX_VALUE = MessageUid.of(Long.MAX_VALUE);
    public static final MessageUid MIN_VALUE = MessageUid.of(1L);
    private final long uid;

    public static MessageUid of(long uid) {
        return new MessageUid(uid);
    }

    private MessageUid(long uid) {
        this.uid = uid;
    }

    public MessageRange toRange() {
        return MessageRange.one(this);
    }

    @Override
    public int compareTo(MessageUid o) {
        return Long.compare(this.uid, o.uid);
    }

    public long asLong() {
        return this.uid;
    }

    public int hashCode() {
        return Long.hashCode(this.uid);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageUid) {
            MessageUid other = (MessageUid)obj;
            return other.uid == this.uid;
        }
        return false;
    }

    public String toString() {
        return "MessageUid{uid=" + this.uid + "}";
    }

    public MessageUid next() {
        return this.next(1);
    }

    public MessageUid next(int count) {
        Preconditions.checkArgument(count > 0);
        return new MessageUid(this.uid + (long)count);
    }

    public boolean isFirst() {
        return this.equals(MIN_VALUE);
    }

    public MessageUid previous() {
        if (this.compareTo(MIN_VALUE) > 0) {
            return new MessageUid(this.uid - 1L);
        }
        return MIN_VALUE;
    }

    public long distance(MessageUid other) {
        Preconditions.checkNotNull(other);
        return other.uid - this.uid;
    }
}

