/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.security.SecureRandom;
import java.time.Duration;
import org.apache.james.events.RetryBackoffConfiguration;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

class WaitDelayGenerator {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final RetryBackoffConfiguration retryBackoff;

    static WaitDelayGenerator of(RetryBackoffConfiguration retryBackoff) {
        return new WaitDelayGenerator(retryBackoff);
    }

    private static Duration randomBetween(Duration base, Duration jitter) {
        Preconditions.checkArgument((!jitter.isNegative() ? 1 : 0) != 0, (Object)"jitter value should always be positive");
        if (jitter.isZero()) {
            return base;
        }
        long maxJitterAsMillis = jitter.toMillis();
        long jitterAsMillis = SECURE_RANDOM.nextInt(Ints.checkedCast((long)(maxJitterAsMillis * 2L))) / 2;
        return base.plusMillis(jitterAsMillis);
    }

    private WaitDelayGenerator(RetryBackoffConfiguration retryBackoff) {
        this.retryBackoff = retryBackoff;
    }

    Mono<Integer> delayIfHaveTo(int retryCount) {
        Mono countRetryMono = Mono.just((Object)retryCount);
        if (!this.shouldDelay(retryCount)) {
            return countRetryMono;
        }
        return countRetryMono.delayElement(this.generateDelay(retryCount), Schedulers.elastic());
    }

    @VisibleForTesting
    Duration generateDelay(int retryCount) {
        if (!this.shouldDelay(retryCount)) {
            return Duration.ZERO;
        }
        long exponentialFactor = Double.valueOf(Math.pow(2.0, retryCount - 1)).longValue();
        Duration minDelay = this.retryBackoff.getFirstBackoff().multipliedBy(exponentialFactor);
        Duration jitterDelay = this.retryBackoff.getFirstBackoff().multipliedBy(Double.valueOf(this.retryBackoff.getJitterFactor() * 100.0).intValue()).dividedBy(100L);
        return WaitDelayGenerator.randomBetween(minDelay, jitterDelay);
    }

    private boolean shouldDelay(int retryCount) {
        return retryCount >= 1 && retryCount <= this.retryBackoff.getMaxRetries();
    }
}

