/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.spamassassin;

import com.github.fge.lambdas.Throwing;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.spamassassin.SpamAssassinConfiguration;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.spamassassin.SpamAssassinInvoker;
import org.apache.james.util.Host;

public class SpamAssassin {
    private final MetricFactory metricFactory;
    private final SpamAssassinConfiguration spamAssassinConfiguration;

    @Inject
    public SpamAssassin(MetricFactory metricFactory, SpamAssassinConfiguration spamAssassinConfiguration) {
        this.metricFactory = metricFactory;
        this.spamAssassinConfiguration = spamAssassinConfiguration;
    }

    public void learnSpam(List<InputStream> messages, Username username) {
        if (this.spamAssassinConfiguration.isEnable()) {
            Host host = this.spamAssassinConfiguration.getHost().get();
            SpamAssassinInvoker invoker = new SpamAssassinInvoker(this.metricFactory, host.getHostName(), host.getPort());
            messages.forEach(Throwing.consumer(message -> invoker.learnAsSpam(message, username)));
        }
    }

    public void learnHam(List<InputStream> messages, Username username) {
        if (this.spamAssassinConfiguration.isEnable()) {
            Host host = this.spamAssassinConfiguration.getHost().get();
            SpamAssassinInvoker invoker = new SpamAssassinInvoker(this.metricFactory, host.getHostName(), host.getPort());
            messages.forEach(Throwing.consumer(message -> invoker.learnAsHam(message, username)));
        }
    }
}

