/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.v7.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.elasticsearch.v7.json.HeaderCollection;
import org.apache.james.mailbox.elasticsearch.v7.json.MimePartContainerBuilder;
import org.apache.james.mailbox.extractor.ParsedContent;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.store.extractor.DefaultTextExtractor;
import org.apache.james.mime4j.stream.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimePart {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimePart.class);
    private final HeaderCollection headerCollection;
    private final Optional<String> bodyTextContent;
    private final Optional<ContentType.MediaType> mediaType;
    private final Optional<ContentType.SubType> subType;
    private final Optional<String> fileName;
    private final Optional<String> fileExtension;
    private final Optional<String> contentDisposition;
    private final List<MimePart> attachments;

    public static Builder builder() {
        return new Builder();
    }

    private MimePart(HeaderCollection headerCollection, Optional<String> bodyTextContent, Optional<ContentType.MediaType> mediaType, Optional<ContentType.SubType> subType, Optional<String> fileName, Optional<String> fileExtension, Optional<String> contentDisposition, List<MimePart> attachments) {
        this.headerCollection = headerCollection;
        this.mediaType = mediaType;
        this.subType = subType;
        this.fileName = fileName;
        this.fileExtension = fileExtension;
        this.contentDisposition = contentDisposition;
        this.attachments = attachments;
        this.bodyTextContent = bodyTextContent;
    }

    @JsonIgnore
    public List<MimePart> getAttachments() {
        return this.attachments;
    }

    @JsonIgnore
    public HeaderCollection getHeaderCollection() {
        return this.headerCollection;
    }

    @JsonProperty(value="fileName")
    public Optional<String> getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="fileExtension")
    public Optional<String> getFileExtension() {
        return this.fileExtension;
    }

    @JsonProperty(value="mediaType")
    public Optional<String> getMediaType() {
        return this.mediaType.map(ContentType.MediaType::asString);
    }

    @JsonProperty(value="subtype")
    public Optional<String> getSubType() {
        return this.subType.map(ContentType.SubType::asString);
    }

    @JsonProperty(value="contentDisposition")
    public Optional<String> getContentDisposition() {
        return this.contentDisposition;
    }

    @JsonProperty(value="textContent")
    public Optional<String> getTextualBody() {
        return this.bodyTextContent;
    }

    @JsonIgnore
    public Optional<String> locateFirstTextBody() {
        return this.firstBody(this.textAttachments().filter(this::isPlainSubType));
    }

    @JsonIgnore
    public Optional<String> locateFirstHtmlBody() {
        return this.firstBody(this.textAttachments().filter(this::isHtmlSubType));
    }

    private Optional<String> firstBody(Stream<MimePart> mimeParts) {
        return mimeParts.map(mimePart -> mimePart.bodyTextContent).flatMap(Optional::stream).findFirst();
    }

    private Stream<MimePart> textAttachments() {
        return Stream.concat(Stream.of(this), this.attachments.stream()).filter(this::isTextMediaType);
    }

    private boolean isTextMediaType(MimePart mimePart) {
        return mimePart.getMediaType().filter("text"::equals).isPresent();
    }

    private boolean isPlainSubType(MimePart mimePart) {
        return mimePart.getSubType().filter("plain"::equals).isPresent();
    }

    private boolean isHtmlSubType(MimePart mimePart) {
        return mimePart.getSubType().filter("html"::equals).isPresent();
    }

    @JsonIgnore
    public Stream<MimePart> getAttachmentsStream() {
        return this.attachments.stream().flatMap(mimePart -> Stream.concat(Stream.of(mimePart), mimePart.getAttachmentsStream())).filter(mimePart -> mimePart.contentDisposition.isPresent());
    }

    public static class Builder
    implements MimePartContainerBuilder {
        private final HeaderCollection.Builder headerCollectionBuilder;
        private Optional<InputStream> bodyContent;
        private final List<MimePart> children = Lists.newArrayList();
        private Optional<ContentType.MediaType> mediaType;
        private Optional<ContentType.SubType> subType;
        private Optional<String> fileName;
        private Optional<String> fileExtension;
        private Optional<String> contentDisposition;
        private Optional<Charset> charset;
        private TextExtractor textExtractor;

        private Builder() {
            this.headerCollectionBuilder = HeaderCollection.builder();
            this.bodyContent = Optional.empty();
            this.mediaType = Optional.empty();
            this.subType = Optional.empty();
            this.fileName = Optional.empty();
            this.fileExtension = Optional.empty();
            this.contentDisposition = Optional.empty();
            this.charset = Optional.empty();
            this.textExtractor = new DefaultTextExtractor();
        }

        @Override
        public Builder addToHeaders(Field field) {
            this.headerCollectionBuilder.add(field);
            return this;
        }

        @Override
        public Builder addBodyContent(InputStream bodyContent) {
            this.bodyContent = Optional.of(bodyContent);
            return this;
        }

        @Override
        public Builder addChild(MimePart mimePart) {
            this.children.add(mimePart);
            return this;
        }

        @Override
        public Builder addFileName(String fileName) {
            this.fileName = Optional.ofNullable(fileName);
            this.fileExtension = this.fileName.map(FilenameUtils::getExtension);
            return this;
        }

        @Override
        public Builder addMediaType(ContentType.MediaType mediaType) {
            this.mediaType = Optional.ofNullable(mediaType);
            return this;
        }

        @Override
        public Builder addSubType(ContentType.SubType subType) {
            this.subType = Optional.of(subType);
            return this;
        }

        @Override
        public Builder addContentDisposition(String contentDisposition) {
            this.contentDisposition = Optional.ofNullable(contentDisposition);
            return this;
        }

        @Override
        public MimePartContainerBuilder using(TextExtractor textExtractor) {
            Preconditions.checkArgument((textExtractor != null ? 1 : 0) != 0, (Object)"Provided text extractor should not be null");
            this.textExtractor = textExtractor;
            return this;
        }

        @Override
        public MimePartContainerBuilder charset(Charset charset) {
            this.charset = Optional.of(charset);
            return this;
        }

        @Override
        public MimePart build() {
            Optional<ParsedContent> parsedContent = this.parseContent(this.textExtractor);
            return new MimePart(this.headerCollectionBuilder.build(), parsedContent.flatMap(ParsedContent::getTextualContent), this.mediaType, this.subType, this.fileName, this.fileExtension, this.contentDisposition, this.children);
        }

        private Optional<ParsedContent> parseContent(TextExtractor textExtractor) {
            if (this.bodyContent.isPresent()) {
                try {
                    return Optional.of(this.extractText(textExtractor, this.bodyContent.get()));
                }
                catch (Exception e) {
                    LOGGER.warn("Failed parsing attachment", (Throwable)e);
                }
            }
            return Optional.empty();
        }

        private ParsedContent extractText(TextExtractor textExtractor, InputStream bodyContent) throws Exception {
            if (this.shouldPerformTextExtraction()) {
                return textExtractor.extractContent(bodyContent, (ContentType)this.computeContentType().orElse(null));
            }
            return new ParsedContent(Optional.ofNullable(IOUtils.toString((InputStream)bodyContent, (Charset)this.charset.orElse(StandardCharsets.UTF_8))), (Map)ImmutableMap.of());
        }

        private boolean shouldPerformTextExtraction() {
            return this.isTextBody() == false || this.isHtml() != false;
        }

        private Boolean isTextBody() {
            return this.mediaType.map(arg_0 -> ((ContentType.MediaType)ContentType.MediaType.of((String)"text")).equals(arg_0)).orElse(false);
        }

        /*
         * Enabled aggressive block sorting
         */
        private Boolean isHtml() {
            boolean bl;
            if (this.isTextBody().booleanValue()) {
                if (this.subType.map(arg_0 -> ((ContentType.SubType)ContentType.SubType.of((String)"html")).equals(arg_0)).orElse(false).booleanValue()) {
                    bl = true;
                    return bl;
                }
            }
            bl = false;
            return bl;
        }

        private Optional<ContentType> computeContentType() {
            if (this.mediaType.isPresent() && this.subType.isPresent()) {
                return Optional.of(ContentType.of((ContentType.MimeType)ContentType.MimeType.of((ContentType.MediaType)this.mediaType.get(), (ContentType.SubType)this.subType.get()), this.charset));
            }
            return Optional.empty();
        }
    }
}

