/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.v7;

import org.apache.james.backends.es.v7.AliasName;
import org.apache.james.backends.es.v7.ElasticSearchConfiguration;
import org.apache.james.backends.es.v7.IndexCreationFactory;
import org.apache.james.backends.es.v7.IndexName;
import org.apache.james.backends.es.v7.ReactorElasticSearchClient;
import org.apache.james.backends.es.v7.ReadAliasName;
import org.apache.james.backends.es.v7.WriteAliasName;
import org.apache.james.mailbox.elasticsearch.v7.MailboxElasticSearchConstants;
import org.apache.james.mailbox.elasticsearch.v7.MailboxMappingFactory;

public class MailboxIndexCreationUtil {
    public static ReactorElasticSearchClient prepareClient(ReactorElasticSearchClient client, ReadAliasName readAlias, WriteAliasName writeAlias, IndexName indexName, ElasticSearchConfiguration configuration) {
        return new IndexCreationFactory(configuration).useIndex(indexName).addAlias((AliasName)readAlias).addAlias((AliasName)writeAlias).createIndexAndAliases(client, MailboxMappingFactory.getMappingContent());
    }

    public static ReactorElasticSearchClient prepareDefaultClient(ReactorElasticSearchClient client, ElasticSearchConfiguration configuration) {
        return MailboxIndexCreationUtil.prepareClient(client, MailboxElasticSearchConstants.DEFAULT_MAILBOX_READ_ALIAS, MailboxElasticSearchConstants.DEFAULT_MAILBOX_WRITE_ALIAS, MailboxElasticSearchConstants.DEFAULT_MAILBOX_INDEX, configuration);
    }
}

