/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remote.delivery;

import java.util.Iterator;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.TemporaryResolutionException;
import org.apache.james.dnsservice.library.MXHostAddressIterator;
import org.apache.james.transport.mailets.remote.delivery.RemoteDeliveryConfiguration;
import org.apache.mailet.HostAddress;

public class DnsHelper {
    public static final boolean USE_SEVERAL_IP = false;
    private final DNSService dnsServer;
    private final RemoteDeliveryConfiguration configuration;

    public DnsHelper(DNSService dnsServer, RemoteDeliveryConfiguration configuration) {
        this.dnsServer = dnsServer;
        this.configuration = configuration;
    }

    public Iterator<HostAddress> retrieveHostAddressIterator(String host, boolean smtps) throws TemporaryResolutionException {
        if (this.configuration.getGatewayServer().isEmpty()) {
            return new MXHostAddressIterator(this.dnsServer.findMXRecords(host).iterator(), this.dnsServer, false, smtps);
        }
        return new MXHostAddressIterator(this.configuration.getGatewayServer().iterator(), this.dnsServer, false, smtps);
    }
}

