/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.executor;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.DNSResponse;
import org.apache.james.jspf.core.Logger;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFCheckerExceptionCatcher;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.SPFResultException;
import org.apache.james.jspf.core.exceptions.TimeoutException;
import org.apache.james.jspf.executor.DNSAsynchLookupService;
import org.apache.james.jspf.executor.FutureSPFResult;
import org.apache.james.jspf.executor.IResponse;
import org.apache.james.jspf.executor.IResponseQueue;
import org.apache.james.jspf.executor.SPFExecutor;

public class StagedMultipleSPFExecutor
implements SPFExecutor,
Runnable {
    private static final String ATTRIBUTE_STAGED_EXECUTOR_CONTINUATION = "StagedMultipleSPFExecutor.continuation";
    private static short id;
    private Logger log;
    private DNSAsynchLookupService dnsProbe;
    private Thread worker;
    private Map<Integer, SPFSession> sessions;
    private Map<Integer, FutureSPFResult> results;
    private ResponseQueueImpl responseQueue;

    private synchronized int nextId() {
        short s = id;
        id = (short)(s + 1);
        return s;
    }

    public StagedMultipleSPFExecutor(Logger log, DNSAsynchLookupService service) {
        this.log = log;
        this.dnsProbe = service;
        this.responseQueue = new ResponseQueueImpl();
        this.sessions = Collections.synchronizedMap(new HashMap());
        this.results = Collections.synchronizedMap(new HashMap());
        this.worker = new Thread(this);
        this.worker.setDaemon(true);
        this.worker.setName("SPFExecutor");
        this.worker.start();
    }

    public void execute(SPFSession session, FutureSPFResult result) {
        this.execute(session, result, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SPFSession session, FutureSPFResult result, boolean throttle) {
        SPFChecker checker;
        while ((checker = session.popChecker()) != null) {
            this.log.debug("Executing checker: " + checker);
            try {
                DNSLookupContinuation cont = checker.checkSPF(session);
                if (cont == null) continue;
                this.invokeAsynchService(session, result, cont, throttle);
                return;
            }
            catch (Exception e2) {
                while (e2 != null) {
                    SPFResultException e2;
                    while (checker == null || !(checker instanceof SPFCheckerExceptionCatcher)) {
                        checker = session.popChecker();
                    }
                    try {
                        ((SPFCheckerExceptionCatcher)((Object)checker)).onException(e2, session);
                        e2 = null;
                    }
                    catch (SPFResultException ex) {
                        e2 = ex;
                    }
                    finally {
                        checker = null;
                    }
                }
            }
        }
        result.setSPFResult(session);
    }

    private synchronized void invokeAsynchService(SPFSession session, FutureSPFResult result, DNSLookupContinuation cont, boolean throttle) {
        while (throttle && this.results.size() > 50) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        int nextId = this.nextId();
        this.sessions.put(new Integer(nextId), session);
        this.results.put(new Integer(nextId), result);
        session.setAttribute(ATTRIBUTE_STAGED_EXECUTOR_CONTINUATION, cont);
        this.dnsProbe.getRecordsAsynch(cont.getRequest(), nextId, this.responseQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            IResponse resp = this.responseQueue.removeResponse();
            Integer respId = (Integer)resp.getId();
            SPFSession session = this.sessions.remove(respId);
            FutureSPFResult result = this.results.remove(respId);
            DNSLookupContinuation cont = (DNSLookupContinuation)session.getAttribute(ATTRIBUTE_STAGED_EXECUTOR_CONTINUATION);
            DNSResponse response = resp.getException() != null ? new DNSResponse((TimeoutException)resp.getException()) : new DNSResponse(resp.getValue());
            try {
                cont = cont.getListener().onDNSResponse(response, session);
                if (cont != null) {
                    this.invokeAsynchService(session, result, cont, false);
                    continue;
                }
                this.execute(session, result, false);
                continue;
            }
            catch (Exception e2) {
                SPFChecker checker = null;
                while (e2 != null) {
                    SPFResultException e2;
                    while (checker == null || !(checker instanceof SPFCheckerExceptionCatcher)) {
                        checker = session.popChecker();
                    }
                    try {
                        ((SPFCheckerExceptionCatcher)((Object)checker)).onException(e2, session);
                        e2 = null;
                    }
                    catch (SPFResultException ex) {
                        e2 = ex;
                    }
                    finally {
                        checker = null;
                    }
                }
                this.execute(session, result, false);
                continue;
            }
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResponseQueueImpl
    extends LinkedList<IResponse>
    implements IResponseQueue {
        private static final long serialVersionUID = 5714025260393791651L;
        private int waitingThreads = 0;

        private ResponseQueueImpl() {
        }

        @Override
        public synchronized void insertResponse(IResponse r) {
            this.addLast(r);
            this.notify();
        }

        @Override
        public synchronized IResponse removeResponse() {
            if (this.size() - this.waitingThreads <= 0) {
                try {
                    ++this.waitingThreads;
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                --this.waitingThreads;
            }
            return (IResponse)this.removeFirst();
        }
    }
}

