/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import java.io.Closeable;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.Optional;
import javax.net.ssl.SSLEngine;
import org.apache.james.protocols.api.Encryption;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.ProtocolSessionImpl;
import org.apache.james.protocols.api.ProtocolTransport;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ConnectHandler;
import org.apache.james.protocols.api.handler.DisconnectHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.api.handler.ProtocolHandlerChain;
import org.apache.james.protocols.api.handler.ProtocolHandlerResultHandler;
import org.apache.james.protocols.netty.NettyProtocolTransport;
import org.apache.james.protocols.netty.ProtocolMDCContextFactory;
import org.apache.james.util.MDCBuilder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class BasicChannelUpstreamHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicChannelUpstreamHandler.class);
    private static final ProtocolSession.AttachmentKey<MDCBuilder> MDC_KEY = ProtocolSession.AttachmentKey.of((String)"bound_MDC", MDCBuilder.class);
    private final ProtocolMDCContextFactory mdcContextFactory;
    protected final Protocol protocol;
    protected final ProtocolHandlerChain chain;
    protected final Encryption secure;

    public BasicChannelUpstreamHandler(ProtocolMDCContextFactory mdcContextFactory, Protocol protocol) {
        this(mdcContextFactory, protocol, null);
    }

    public BasicChannelUpstreamHandler(ProtocolMDCContextFactory mdcContextFactory, Protocol protocol, Encryption secure) {
        this.mdcContextFactory = mdcContextFactory;
        this.protocol = protocol;
        this.chain = protocol.getProtocolChain();
        this.secure = secure;
    }

    public void channelBound(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        MDCBuilder boundMDC = this.mdcContextFactory.onBound(this.protocol, ctx);
        try (Closeable closeable = boundMDC.build();){
            ProtocolSession session = this.createSession(ctx);
            session.setAttachment(MDC_KEY, (Object)boundMDC, ProtocolSession.State.Connection);
            ctx.setAttachment((Object)session);
            super.channelBound(ctx, e);
        }
    }

    private MDCBuilder mdc(ChannelHandlerContext ctx) {
        ProtocolSession session = (ProtocolSession)ctx.getAttachment();
        return Optional.ofNullable(session).flatMap(s -> s.getAttachment(MDC_KEY, ProtocolSession.State.Connection)).map(mdc -> this.mdcContextFactory.withContext(session).addToContext(mdc)).orElseGet(MDCBuilder::create);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try (Closeable closeable = this.mdc(ctx).build();){
            LinkedList connectHandlers = this.chain.getHandlers(ConnectHandler.class);
            LinkedList resultHandlers = this.chain.getHandlers(ProtocolHandlerResultHandler.class);
            ProtocolSession session = (ProtocolSession)ctx.getAttachment();
            LOGGER.info("Connection established from {}", (Object)session.getRemoteAddress().getAddress().getHostAddress());
            if (connectHandlers != null) {
                for (ConnectHandler cHandler : connectHandlers) {
                    long start = System.currentTimeMillis();
                    Response response = cHandler.onConnect(session);
                    long executionTime = System.currentTimeMillis() - start;
                    for (ProtocolHandlerResultHandler resultHandler : resultHandlers) {
                        resultHandler.onResponse(session, response, executionTime, (ProtocolHandler)cHandler);
                    }
                    if (response == null) continue;
                    ((ProtocolSessionImpl)session).getProtocolTransport().writeResponse(response, session);
                }
            }
            super.channelConnected(ctx, e);
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try (Closeable closeable = this.mdc(ctx).build();){
            LinkedList connectHandlers = this.chain.getHandlers(DisconnectHandler.class);
            ProtocolSession session = (ProtocolSession)ctx.getAttachment();
            if (connectHandlers != null) {
                for (DisconnectHandler connectHandler : connectHandlers) {
                    connectHandler.onDisconnect(session);
                }
            }
            super.channelDisconnected(ctx, e);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        try (Closeable closeable = this.mdc(ctx).build();){
            ProtocolSession pSession = (ProtocolSession)ctx.getAttachment();
            LinkedList lineHandlers = this.chain.getHandlers(LineHandler.class);
            LinkedList resultHandlers = this.chain.getHandlers(ProtocolHandlerResultHandler.class);
            if (lineHandlers.size() > 0) {
                ChannelBuffer buf = (ChannelBuffer)e.getMessage();
                LineHandler lHandler = (LineHandler)lineHandlers.getLast();
                long start = System.currentTimeMillis();
                Response response = lHandler.onLine(pSession, buf.toByteBuffer());
                long executionTime = System.currentTimeMillis() - start;
                for (ProtocolHandlerResultHandler resultHandler : resultHandlers) {
                    response = resultHandler.onResponse(pSession, response, executionTime, (ProtocolHandler)lHandler);
                }
                if (response != null) {
                    ((ProtocolSessionImpl)pSession).getProtocolTransport().writeResponse(response, pSession);
                }
            }
            super.messageReceived(ctx, e);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try (Closeable closeable = this.mdc(ctx).build();){
            ProtocolSession session = (ProtocolSession)ctx.getAttachment();
            LOGGER.info("Connection closed for {}", (Object)session.getRemoteAddress().getAddress().getHostAddress());
            this.cleanup(ctx);
            super.channelClosed(ctx, e);
        }
    }

    protected void cleanup(ChannelHandlerContext ctx) {
        ProtocolSession session = (ProtocolSession)ctx.getAttachment();
        if (session != null) {
            session.resetState();
            session = null;
        }
    }

    protected ProtocolSession createSession(ChannelHandlerContext ctx) throws Exception {
        SSLEngine engine = null;
        if (this.secure != null) {
            engine = this.secure.createSSLEngine();
        }
        return this.protocol.newSession((ProtocolTransport)new NettyProtocolTransport(ctx.getChannel(), engine));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        try (Closeable closeable = this.mdc(ctx).build();){
            Channel channel = ctx.getChannel();
            ProtocolSession session = (ProtocolSession)ctx.getAttachment();
            if (e.getCause() instanceof TooLongFrameException && session != null) {
                Response r = session.newLineTooLongResponse();
                ProtocolTransport transport = ((ProtocolSessionImpl)session).getProtocolTransport();
                if (r != null) {
                    transport.writeResponse(r, session);
                }
            } else {
                if (channel.isConnected() && session != null) {
                    ProtocolTransport transport = ((ProtocolSessionImpl)session).getProtocolTransport();
                    Response r = session.newFatalErrorResponse();
                    if (r != null) {
                        transport.writeResponse(r, session);
                    }
                    transport.writeResponse(Response.DISCONNECT, session);
                }
                if (e.getCause() instanceof ClosedChannelException) {
                    LOGGER.info("Channel closed before we could send in flight messages to the users (ClosedChannelException): {}", (Object)e.getCause().getMessage());
                } else {
                    LOGGER.error("Unable to process request", e.getCause());
                }
                this.cleanup(ctx);
            }
        }
    }
}

