/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.common.ImmutableList;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Utils;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.MemoMismatchesMatcher;
import org.parboiled.trees.ImmutableGraphNode;

public abstract class AbstractMatcher
extends ImmutableGraphNode<Matcher>
implements Matcher,
Cloneable {
    private String label;
    private boolean nodeSuppressed;
    private boolean subnodesSuppressed;
    private boolean nodeSkipped;
    private Object tag;

    public AbstractMatcher(String string) {
        this(new Rule[0], string);
    }

    public AbstractMatcher(Rule rule, String string) {
        this(new Rule[]{Preconditions.checkArgNotNull(rule, "subRule")}, string);
    }

    public AbstractMatcher(Rule[] ruleArray, String string) {
        super(ImmutableList.of(AbstractMatcher.toMatchers(Preconditions.checkArgNotNull(ruleArray, "subRules"))));
        this.label = string;
    }

    private static Matcher[] toMatchers(Rule[] ruleArray) {
        Matcher[] matcherArray = new Matcher[ruleArray.length];
        for (int i = 0; i < ruleArray.length; ++i) {
            matcherArray[i] = (Matcher)ruleArray[i];
        }
        return matcherArray;
    }

    @Override
    public boolean isNodeSuppressed() {
        return this.nodeSuppressed;
    }

    @Override
    public boolean areSubnodesSuppressed() {
        return this.subnodesSuppressed;
    }

    @Override
    public boolean isNodeSkipped() {
        return this.nodeSkipped;
    }

    @Override
    public boolean areMismatchesMemoed() {
        return false;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean hasCustomLabel() {
        return true;
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public AbstractMatcher label(String string) {
        if (Utils.equal(string, this.label)) {
            return this;
        }
        AbstractMatcher abstractMatcher = this.createClone();
        abstractMatcher.label = string;
        return abstractMatcher;
    }

    @Override
    public Rule suppressNode() {
        if (this.nodeSuppressed) {
            return this;
        }
        AbstractMatcher abstractMatcher = this.createClone();
        abstractMatcher.nodeSuppressed = true;
        return abstractMatcher;
    }

    @Override
    public Rule suppressSubnodes() {
        if (this.subnodesSuppressed) {
            return this;
        }
        AbstractMatcher abstractMatcher = this.createClone();
        abstractMatcher.subnodesSuppressed = true;
        return abstractMatcher;
    }

    @Override
    public Rule skipNode() {
        if (this.nodeSkipped) {
            return this;
        }
        AbstractMatcher abstractMatcher = this.createClone();
        abstractMatcher.nodeSkipped = true;
        return abstractMatcher;
    }

    @Override
    public Rule memoMismatches() {
        return new MemoMismatchesMatcher(this);
    }

    @Override
    public Object getTag() {
        return this.tag;
    }

    @Override
    public void setTag(Object object) {
        this.tag = object;
    }

    @Override
    public MatcherContext getSubContext(MatcherContext matcherContext) {
        return matcherContext.getSubContext(this);
    }

    private AbstractMatcher createClone() {
        try {
            return (AbstractMatcher)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
    }
}

