/*
 * Decompiled with CFR 0.152.
 */
package org.jvyaml;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jvyaml.Emitter;
import org.jvyaml.Resolver;
import org.jvyaml.Serializer;
import org.jvyaml.SerializerException;
import org.jvyaml.YAMLConfig;
import org.jvyaml.events.AliasEvent;
import org.jvyaml.events.DocumentEndEvent;
import org.jvyaml.events.DocumentStartEvent;
import org.jvyaml.events.MappingEndEvent;
import org.jvyaml.events.MappingStartEvent;
import org.jvyaml.events.ScalarEvent;
import org.jvyaml.events.SequenceEndEvent;
import org.jvyaml.events.SequenceStartEvent;
import org.jvyaml.events.StreamEndEvent;
import org.jvyaml.events.StreamStartEvent;
import org.jvyaml.nodes.CollectionNode;
import org.jvyaml.nodes.MappingNode;
import org.jvyaml.nodes.Node;
import org.jvyaml.nodes.ScalarNode;
import org.jvyaml.nodes.SequenceNode;

public class SerializerImpl
implements Serializer {
    private Emitter emitter;
    private Resolver resolver;
    private YAMLConfig options;
    private boolean useExplicitStart;
    private boolean useExplicitEnd;
    private int[] useVersion;
    private boolean useTags;
    private String anchorTemplate;
    private Set serializedNodes;
    private Map anchors;
    private int lastAnchorId;
    private boolean closed;
    private boolean opened;

    public SerializerImpl(Emitter emitter, Resolver resolver, YAMLConfig opts) {
        this.emitter = emitter;
        this.resolver = resolver;
        this.options = opts;
        this.useExplicitStart = opts.explicitStart();
        this.useExplicitEnd = opts.explicitEnd();
        int[] version = new int[2];
        if (opts.useVersion()) {
            String v1 = opts.version();
            int index = v1.indexOf(46);
            version[0] = Integer.parseInt(v1.substring(0, index));
            version[1] = Integer.parseInt(v1.substring(index + 1));
        } else {
            version = null;
        }
        this.useVersion = version;
        this.useTags = opts.useHeader();
        this.anchorTemplate = opts.anchorFormat() == null ? "id{0,number,####}" : opts.anchorFormat();
        this.serializedNodes = new HashSet();
        this.anchors = new HashMap();
        this.lastAnchorId = 0;
        this.closed = false;
        this.opened = false;
    }

    protected boolean ignoreAnchor(Node node) {
        return false;
    }

    public void open() throws IOException {
        if (this.closed || this.opened) {
            if (this.closed) {
                throw new SerializerException("serializer is closed");
            }
            throw new SerializerException("serializer is already opened");
        }
        this.emitter.emit(new StreamStartEvent());
        this.opened = true;
    }

    public void close() throws IOException {
        if (!this.opened) {
            throw new SerializerException("serializer is not opened");
        }
        if (!this.closed) {
            this.emitter.emit(new StreamEndEvent());
            this.closed = true;
            this.opened = false;
        }
    }

    public void serialize(Node node) throws IOException {
        if (!this.closed && !this.opened) {
            throw new SerializerException("serializer is not opened");
        }
        if (this.closed) {
            throw new SerializerException("serializer is closed");
        }
        this.emitter.emit(new DocumentStartEvent(this.useExplicitStart, this.useVersion, null));
        this.anchorNode(node);
        this.serializeNode(node, null, null);
        this.emitter.emit(new DocumentEndEvent(this.useExplicitEnd));
        this.serializedNodes = new HashSet();
        this.anchors = new HashMap();
        this.lastAnchorId = 0;
    }

    private void anchorNode(Node node) {
        block5: {
            block6: {
                if (this.ignoreAnchor(node)) break block5;
                if (!this.anchors.containsKey(node)) break block6;
                String anchor = (String)this.anchors.get(node);
                if (null != anchor) break block5;
                anchor = this.generateAnchor(node);
                this.anchors.put(node, anchor);
                break block5;
            }
            this.anchors.put(node, null);
            if (node instanceof SequenceNode) {
                Iterator iter = ((List)node.getValue()).iterator();
                while (iter.hasNext()) {
                    this.anchorNode((Node)iter.next());
                }
            } else if (node instanceof MappingNode) {
                Map value = (Map)node.getValue();
                Iterator iter = value.keySet().iterator();
                while (iter.hasNext()) {
                    Node key = (Node)iter.next();
                    this.anchorNode(key);
                    this.anchorNode((Node)value.get(key));
                }
            }
        }
    }

    private String generateAnchor(Node node) {
        ++this.lastAnchorId;
        return new MessageFormat(this.anchorTemplate).format(new Object[]{new Integer(this.lastAnchorId)});
    }

    private void serializeNode(Node node, Node parent, Object index) throws IOException {
        String tAlias = (String)this.anchors.get(node);
        if (this.serializedNodes.contains(node) && tAlias != null) {
            this.emitter.emit(new AliasEvent(tAlias));
        } else {
            this.serializedNodes.add(node);
            this.resolver.descendResolver(parent, index);
            if (node instanceof ScalarNode) {
                String detectedTag = this.resolver.resolve(ScalarNode.class, (String)node.getValue(), new boolean[]{true, false});
                String defaultTag = this.resolver.resolve(ScalarNode.class, (String)node.getValue(), new boolean[]{false, true});
                boolean[] implicit = new boolean[]{false, false};
                if (!this.options.explicitTypes()) {
                    implicit[0] = node.getTag().equals(detectedTag);
                    implicit[1] = node.getTag().equals(defaultTag);
                }
                this.emitter.emit(new ScalarEvent(tAlias, node.getTag(), implicit, (String)node.getValue(), ((ScalarNode)node).getStyle()));
            } else if (node instanceof SequenceNode) {
                boolean implicit = !this.options.explicitTypes() && node.getTag().equals(this.resolver.resolve(SequenceNode.class, null, new boolean[]{true, true}));
                this.emitter.emit(new SequenceStartEvent(tAlias, node.getTag(), implicit, ((CollectionNode)node).getFlowStyle()));
                int ix = 0;
                Iterator iter = ((List)node.getValue()).iterator();
                while (iter.hasNext()) {
                    this.serializeNode((Node)iter.next(), node, new Integer(ix++));
                }
                this.emitter.emit(new SequenceEndEvent());
            } else if (node instanceof MappingNode) {
                boolean implicit = !this.options.explicitTypes() && node.getTag().equals(this.resolver.resolve(MappingNode.class, null, new boolean[]{true, true}));
                this.emitter.emit(new MappingStartEvent(tAlias, node.getTag(), implicit, ((CollectionNode)node).getFlowStyle()));
                Map value = (Map)node.getValue();
                Iterator iter = value.keySet().iterator();
                while (iter.hasNext()) {
                    Node key = (Node)iter.next();
                    this.serializeNode(key, node, null);
                    this.serializeNode((Node)value.get(key), node, key);
                }
                this.emitter.emit(new MappingEndEvent());
            }
        }
    }
}

