/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.function.value;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.function.value.ValueWindowFunction;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class LagFunction
extends ValueWindowFunction {
    private final int channel;
    private final int offsetChannel;
    private final int defaultValChannel;
    private final boolean ignoreNull;

    public LagFunction(List<Integer> argumentChannels, boolean ignoreNull) {
        this.channel = argumentChannels.get(0);
        this.offsetChannel = argumentChannels.size() > 1 ? argumentChannels.get(1) : -1;
        this.defaultValChannel = argumentChannels.size() > 2 ? argumentChannels.get(2) : -1;
        this.ignoreNull = ignoreNull;
    }

    @Override
    public void transform(Partition partition, ColumnBuilder builder, int index, int frameStart, int frameEnd) {
        int pos;
        int offset;
        if (this.offsetChannel >= 0 && partition.isNull(this.offsetChannel, index)) {
            builder.appendNull();
            return;
        }
        int n = offset = this.offsetChannel >= 0 ? partition.getInt(this.offsetChannel, index) : 1;
        if (this.ignoreNull) {
            int nonNullCount = 0;
            for (pos = index - 1; pos >= 0 && (partition.isNull(this.channel, pos) || ++nonNullCount != offset); --pos) {
            }
        } else {
            pos = index - offset;
        }
        if (pos >= 0) {
            if (!partition.isNull(this.channel, pos)) {
                partition.writeTo(builder, this.channel, pos);
            } else {
                builder.appendNull();
            }
        } else if (this.defaultValChannel >= 0) {
            this.writeDefaultValue(partition, this.defaultValChannel, index, builder);
        } else {
            builder.appendNull();
        }
    }

    private void writeDefaultValue(Partition partition, int defaultValChannel, int index, ColumnBuilder builder) {
        TSDataType dataType = builder.getDataType();
        switch (dataType) {
            case INT32: 
            case DATE: {
                builder.writeInt(partition.getInt(defaultValChannel, index));
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                builder.writeLong(partition.getLong(defaultValChannel, index));
                return;
            }
            case FLOAT: {
                builder.writeFloat(partition.getFloat(defaultValChannel, index));
                return;
            }
            case DOUBLE: {
                builder.writeDouble(partition.getDouble(defaultValChannel, index));
                return;
            }
            case BOOLEAN: {
                builder.writeBoolean(partition.getBoolean(defaultValChannel, index));
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                builder.writeBinary(partition.getBinary(defaultValChannel, index));
                return;
            }
        }
        throw new UnSupportedDataTypeException("Unsupported default value's data type in Lag: " + dataType);
    }

    @Override
    public boolean needFrame() {
        return false;
    }
}

