/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric.sink;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.agent.task.subtask.sink.PipeSinkSubtask;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataRegionSinkMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeDataRegionSinkMetrics.class);
    private volatile AbstractMetricService metricService;
    private final Map<String, PipeSinkSubtask> connectorMap = new HashMap<String, PipeSinkSubtask>();
    private final Map<String, Rate> tabletRateMap = new ConcurrentHashMap<String, Rate>();
    private final Map<String, Rate> tsFileRateMap = new ConcurrentHashMap<String, Rate>();
    private final Map<String, Rate> pipeHeartbeatRateMap = new ConcurrentHashMap<String, Rate>();
    private final Map<String, Timer> compressionTimerMap = new ConcurrentHashMap<String, Timer>();

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ImmutableSet taskIDs = ImmutableSet.copyOf(this.connectorMap.keySet());
        for (String taskID : taskIDs) {
            this.createMetrics(taskID);
        }
    }

    private void createMetrics(String taskID) {
        this.createAutoGauge(taskID);
        this.createRate(taskID);
        this.createTimer(taskID);
        this.createHistogram(taskID);
    }

    private void createAutoGauge(String taskID) {
        PipeSinkSubtask connector = this.connectorMap.get(taskID);
        this.metricService.createAutoGauge(Metric.UNTRANSFERRED_TABLET_COUNT.toString(), MetricLevel.IMPORTANT, (Object)connector, PipeSinkSubtask::getTabletInsertionEventCount, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.createAutoGauge(Metric.UNTRANSFERRED_TSFILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)connector, PipeSinkSubtask::getTsFileInsertionEventCount, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.createAutoGauge(Metric.UNTRANSFERRED_HEARTBEAT_COUNT.toString(), MetricLevel.IMPORTANT, (Object)connector, PipeSinkSubtask::getPipeHeartbeatEventCount, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.createAutoGauge(Metric.PIPE_ASYNC_CONNECTOR_RETRY_EVENT_QUEUE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)connector, PipeSinkSubtask::getAsyncConnectorRetryEventQueueSize, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.createAutoGauge(Metric.PIPE_PENDING_HANDLERS_SIZE.toString(), MetricLevel.IMPORTANT, (Object)connector, PipeSinkSubtask::getPendingHandlersSize, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.createAutoGauge(Metric.PIPE_TOTAL_UNCOMPRESSED_SIZE.toString(), MetricLevel.IMPORTANT, (Object)connector, PipeSinkSubtask::getTotalUncompressedSize, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.createAutoGauge(Metric.PIPE_TOTAL_COMPRESSED_SIZE.toString(), MetricLevel.IMPORTANT, (Object)connector, PipeSinkSubtask::getTotalCompressedSize, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
    }

    private void createRate(String taskID) {
        PipeSinkSubtask connector = this.connectorMap.get(taskID);
        this.tabletRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_CONNECTOR_TABLET_TRANSFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())}));
        this.tsFileRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_CONNECTOR_TSFILE_TRANSFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())}));
        this.pipeHeartbeatRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_CONNECTOR_HEARTBEAT_TRANSFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())}));
    }

    private void createTimer(String taskID) {
        PipeSinkSubtask connector = this.connectorMap.get(taskID);
        this.compressionTimerMap.putIfAbsent(connector.getAttributeSortedString(), this.metricService.getOrCreateTimer(Metric.PIPE_COMPRESSION_TIME.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())}));
    }

    private void createHistogram(String taskID) {
        PipeSinkSubtask connector = this.connectorMap.get(taskID);
        Histogram tabletBatchSizeHistogram = this.metricService.getOrCreateHistogram(Metric.PIPE_INSERT_NODE_BATCH_SIZE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        connector.setTabletBatchSizeHistogram(tabletBatchSizeHistogram);
        Histogram tsFileBatchSizeHistogram = this.metricService.getOrCreateHistogram(Metric.PIPE_TSFILE_BATCH_SIZE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        connector.setTsFileBatchSizeHistogram(tsFileBatchSizeHistogram);
        Histogram tabletBatchTimeIntervalHistogram = this.metricService.getOrCreateHistogram(Metric.PIPE_INSERT_NODE_BATCH_TIME_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        connector.setTabletBatchTimeIntervalHistogram(tabletBatchTimeIntervalHistogram);
        Histogram tsFileBatchTimeIntervalHistogram = this.metricService.getOrCreateHistogram(Metric.PIPE_TSFILE_BATCH_TIME_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        connector.setTsFileBatchTimeIntervalHistogram(tsFileBatchTimeIntervalHistogram);
        Histogram eventSizeHistogram = this.metricService.getOrCreateHistogram(Metric.PIPE_CONNECTOR_BATCH_SIZE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString()});
        connector.setEventSizeHistogram(eventSizeHistogram);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet taskIDs = ImmutableSet.copyOf(this.connectorMap.keySet());
        for (String taskID : taskIDs) {
            this.deregister(taskID);
        }
        if (!this.connectorMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe data region connector metrics, connector map not empty");
        }
    }

    private void removeMetrics(String taskID) {
        this.removeAutoGauge(taskID);
        this.removeRate(taskID);
        this.removeTimer(taskID);
        this.removeHistogram(taskID);
    }

    private void removeAutoGauge(String taskID) {
        PipeSinkSubtask connector = this.connectorMap.get(taskID);
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNTRANSFERRED_TABLET_COUNT.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNTRANSFERRED_TSFILE_COUNT.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNTRANSFERRED_HEARTBEAT_COUNT.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_ASYNC_CONNECTOR_RETRY_EVENT_QUEUE_SIZE.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_PENDING_HANDLERS_SIZE.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_TOTAL_UNCOMPRESSED_SIZE.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_TOTAL_COMPRESSED_SIZE.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
    }

    private void removeRate(String taskID) {
        PipeSinkSubtask connector = this.connectorMap.get(taskID);
        this.metricService.remove(MetricType.RATE, Metric.PIPE_CONNECTOR_TABLET_TRANSFER.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.RATE, Metric.PIPE_CONNECTOR_TSFILE_TRANSFER.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.RATE, Metric.PIPE_CONNECTOR_HEARTBEAT_TRANSFER.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.INDEX.toString(), String.valueOf(connector.getConnectorIndex()), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.tabletRateMap.remove(taskID);
        this.tsFileRateMap.remove(taskID);
        this.pipeHeartbeatRateMap.remove(taskID);
    }

    private void removeTimer(String taskID) {
        PipeSinkSubtask connector = this.connectorMap.get(taskID);
        this.metricService.remove(MetricType.TIMER, Metric.PIPE_COMPRESSION_TIME.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.compressionTimerMap.remove(connector.getAttributeSortedString());
    }

    private void removeHistogram(String taskID) {
        PipeSinkSubtask connector = this.connectorMap.get(taskID);
        this.metricService.remove(MetricType.HISTOGRAM, Metric.PIPE_INSERT_NODE_BATCH_SIZE.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.HISTOGRAM, Metric.PIPE_TSFILE_BATCH_SIZE.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.HISTOGRAM, Metric.PIPE_INSERT_NODE_BATCH_TIME_COST.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.HISTOGRAM, Metric.PIPE_TSFILE_BATCH_TIME_COST.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.metricService.remove(MetricType.HISTOGRAM, Metric.PIPE_CONNECTOR_BATCH_SIZE.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString()});
    }

    public void register(@NonNull PipeSinkSubtask pipeSinkSubtask) {
        String taskID = pipeSinkSubtask.getTaskID();
        this.connectorMap.putIfAbsent(taskID, pipeSinkSubtask);
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(taskID);
        }
    }

    public void deregister(String taskID) {
        if (!this.connectorMap.containsKey(taskID)) {
            LOGGER.warn("Failed to deregister pipe data region connector metrics, PipeConnectorSubtask({}) does not exist", (Object)taskID);
            return;
        }
        if (Objects.nonNull(this.metricService)) {
            this.removeMetrics(taskID);
        }
        this.connectorMap.remove(taskID);
    }

    public void markTabletEvent(String taskID) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        Rate rate = this.tabletRateMap.get(taskID);
        if (rate == null) {
            LOGGER.info("Failed to mark pipe data region connector tablet event, PipeConnectorSubtask({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public void markTsFileEvent(String taskID) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        Rate rate = this.tsFileRateMap.get(taskID);
        if (rate == null) {
            LOGGER.info("Failed to mark pipe data region connector tsfile event, PipeConnectorSubtask({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public void markPipeHeartbeatEvent(String taskID) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        Rate rate = this.pipeHeartbeatRateMap.get(taskID);
        if (rate == null) {
            return;
        }
        rate.mark();
    }

    public Timer getCompressionTimer(String attributeSortedString) {
        return Objects.isNull(this.metricService) ? null : this.compressionTimerMap.get(attributeSortedString);
    }

    public static PipeDataRegionSinkMetrics getInstance() {
        return PipeSinkMetricsHolder.INSTANCE;
    }

    private PipeDataRegionSinkMetrics() {
    }

    private static class PipeSinkMetricsHolder {
        private static final PipeDataRegionSinkMetrics INSTANCE = new PipeDataRegionSinkMetrics();

        private PipeSinkMetricsHolder() {
        }
    }
}

