/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.result;

public class Result<T, E> {
    private final T ok;
    private final E err;

    private Result(T ok, E err) {
        this.ok = ok;
        this.err = err;
    }

    public static <T, E> Result<T, E> ok(T value) {
        return new Result<T, Object>(value, null);
    }

    public static <T, E> Result<T, E> err(E error) {
        return new Result<Object, E>(null, error);
    }

    public boolean isOk() {
        return this.ok != null;
    }

    public boolean isErr() {
        return this.err != null;
    }

    public T getOk() {
        return this.ok;
    }

    public E getErr() {
        return this.err;
    }
}

