/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.ListNode2;

public class DoublyLinkedList<T>
implements Iterable<T> {
    protected int size;
    protected ListNode2<T> tail;
    protected ListNode2<T> head;

    public ListNode2<T> add(T value) {
        ListNode2<T> node = new ListNode2<T>(value);
        if (this.size++ == 0) {
            this.tail = node;
        } else {
            node.prev = this.head;
            this.head.next = node;
        }
        this.head = node;
        return node;
    }

    public ListNode2<T> enqueue(T value) {
        ListNode2<T> node = new ListNode2<T>(value);
        if (this.size++ == 0) {
            this.head = node;
        } else {
            node.next = this.tail;
            this.tail.prev = node;
        }
        this.tail = node;
        return node;
    }

    public void add(ListNode2<T> node) {
        node.prev = this.head;
        node.next = null;
        if (this.size++ == 0) {
            this.tail = node;
        } else {
            this.head.next = node;
        }
        this.head = node;
    }

    public ListNode2<T> addAfter(ListNode2<T> node, T value) {
        ListNode2<T> newNode = new ListNode2<T>(value);
        this.addAfter(node, newNode);
        return newNode;
    }

    public void addAfter(ListNode2<T> node, ListNode2<T> newNode) {
        newNode.next = node.next;
        newNode.prev = node;
        node.next = newNode;
        if (newNode.next == null) {
            this.head = newNode;
        } else {
            newNode.next.prev = newNode;
        }
        ++this.size;
    }

    public void remove(ListNode2<T> node) {
        if (node == this.tail) {
            this.tail = node.next;
        } else {
            node.prev.next = node.next;
        }
        if (node == this.head) {
            this.head = node.prev;
        } else {
            node.next.prev = node.prev;
        }
        --this.size;
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<T> iterator() {
        return new DoublyLinkedListIterator(this);
    }

    public T first() {
        return this.tail == null ? null : (T)this.tail.getValue();
    }

    public T last() {
        return this.head == null ? null : (T)this.head.getValue();
    }

    public ListNode2<T> head() {
        return this.head;
    }

    public ListNode2<T> tail() {
        return this.tail;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public T[] toArray() {
        Object[] a = new Object[this.size];
        int i = 0;
        for (T v : this) {
            a[i++] = v;
        }
        return a;
    }

    protected class DoublyLinkedListIterator
    implements Iterator<T> {
        protected DoublyLinkedList<T> list;
        protected ListNode2<T> itr;
        protected int length;

        public DoublyLinkedListIterator(DoublyLinkedList<T> list) {
            this.length = list.size;
            this.list = list;
            this.itr = list.tail;
        }

        @Override
        public boolean hasNext() {
            return this.itr != null;
        }

        @Override
        public T next() {
            if (this.length != this.list.size) {
                throw new ConcurrentModificationException();
            }
            Object next = this.itr.value;
            this.itr = this.itr.next;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

