/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl.values;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ComparisonFilter
extends SchemaFilter {
    private final Operator operator;
    private final String value;

    public ComparisonFilter(Operator operator, String value) {
        Objects.requireNonNull(operator, "operator is null");
        Objects.requireNonNull(value, "value is null");
        this.operator = operator;
        this.value = value;
    }

    public ComparisonFilter(ByteBuffer byteBuffer) {
        this.operator = Operator.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        this.value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public <C> Boolean accept(SchemaFilterVisitor<C> visitor, C node) {
        return visitor.visitComparisonFilter(this, node);
    }

    @Override
    public SchemaFilterType getSchemaFilterType() {
        return SchemaFilterType.COMPARISON;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.operator.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.value, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.operator.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.value, (OutputStream)stream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparisonFilter that = (ComparisonFilter)o;
        return Objects.equals((Object)this.operator, (Object)that.operator) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.value});
    }

    public static enum Operator {
        NOT_EQUAL,
        LESS_THAN,
        LESS_THAN_OR_EQUAL,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL;

    }
}

