/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.udf;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.udf.access.RecordIterator;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.MultiColumnTransformer;
import org.apache.iotdb.udf.api.relational.ScalarFunction;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class UserDefineScalarFunctionTransformer
extends MultiColumnTransformer {
    private final ScalarFunction scalarFunction;
    private final List<Type> inputTypes;

    public UserDefineScalarFunctionTransformer(Type returnType, ScalarFunction scalarFunction, List<ColumnTransformer> childrenTransformers) {
        super(returnType, childrenTransformers);
        this.scalarFunction = scalarFunction;
        this.inputTypes = childrenTransformers.stream().map(ColumnTransformer::getType).collect(Collectors.toList());
    }

    @Override
    protected void doTransform(List<Column> childrenColumns, ColumnBuilder builder, int positionCount) {
        RecordIterator iterator = new RecordIterator(childrenColumns, this.inputTypes, positionCount);
        while (iterator.hasNext()) {
            try {
                Object result = this.scalarFunction.evaluate(iterator.next());
                if (result == null) {
                    builder.appendNull();
                    continue;
                }
                builder.writeObject(result);
            }
            catch (Exception e) {
                throw new RuntimeException("Error occurs when evaluating user-defined scalar function " + this.scalarFunction.getClass().getName(), e);
            }
        }
    }

    @Override
    protected void doTransform(List<Column> childrenColumns, ColumnBuilder builder, int positionCount, boolean[] selection) {
        RecordIterator iterator = new RecordIterator(childrenColumns, this.inputTypes, positionCount);
        int i = 0;
        while (iterator.hasNext()) {
            try {
                Record input = iterator.next();
                if (selection[i++]) {
                    builder.appendNull();
                    continue;
                }
                Object result = this.scalarFunction.evaluate(input);
                if (result == null) {
                    builder.appendNull();
                    continue;
                }
                builder.writeObject(result);
            }
            catch (Throwable e) {
                throw new RuntimeException("Error occurs when evaluating user-defined scalar function " + this.scalarFunction.getClass().getName(), e);
            }
        }
    }

    @Override
    public void close() {
        super.close();
        this.scalarFunction.beforeDestroy();
    }

    @Override
    protected void checkType() {
    }
}

