/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteDatabaseStatement
extends Statement
implements IConfigStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteDatabaseStatement.class);
    private List<String> prefixPathList;

    public DeleteDatabaseStatement() {
        this.statementType = StatementType.DELETE_STORAGE_GROUP;
    }

    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        for (String prefixPath : this.prefixPathList) {
            try {
                paths.add(new PartialPath(prefixPath));
            }
            catch (IllegalPathException e) {
                LOGGER.error("{} is not a legal path", (Object)prefixPath, (Object)e);
            }
        }
        return paths;
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.MANAGE_DATABASE), PrivilegeType.MANAGE_DATABASE);
    }

    public List<String> getPrefixPath() {
        return this.prefixPathList;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitDeleteStorageGroup(this, context);
    }

    public void setPrefixPath(List<String> prefixPathList) {
        this.prefixPathList = prefixPathList;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }
}

