/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.pipe.sink.payload.pipeconsensus.request.PipeConsensusRequestType;
import org.apache.iotdb.commons.pipe.sink.payload.pipeconsensus.request.PipeConsensusRequestVersion;
import org.apache.iotdb.consensus.pipe.thrift.TCommitId;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.AbstractDeleteDataNode;
import org.apache.tsfile.utils.PublicBAOS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConsensusDeleteNodeReq
extends TPipeConsensusTransferReq {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusDeleteNodeReq.class);
    private transient AbstractDeleteDataNode deleteDataNode;

    private PipeConsensusDeleteNodeReq() {
    }

    public AbstractDeleteDataNode getDeleteDataNode() {
        return this.deleteDataNode;
    }

    public static PipeConsensusDeleteNodeReq toTPipeConsensusTransferReq(AbstractDeleteDataNode deleteDataNode, TCommitId commitId, TConsensusGroupId consensusGroupId, ProgressIndex progressIndex, int thisDataNodeId) {
        PipeConsensusDeleteNodeReq req = new PipeConsensusDeleteNodeReq();
        req.deleteDataNode = deleteDataNode;
        req.commitId = commitId;
        req.consensusGroupId = consensusGroupId;
        req.dataNodeId = thisDataNodeId;
        req.version = PipeConsensusRequestVersion.VERSION_1.getVersion();
        req.type = PipeConsensusRequestType.TRANSFER_DELETION.getType();
        req.body = deleteDataNode.serializeToByteBuffer();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            progressIndex.serialize((OutputStream)outputStream);
            req.progressIndex = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to serialize progress index {}", (Object)progressIndex, (Object)e);
        }
        return req;
    }

    public static PipeConsensusDeleteNodeReq fromTPipeConsensusTransferReq(TPipeConsensusTransferReq transferReq) {
        PipeConsensusDeleteNodeReq deleteNodeReq = new PipeConsensusDeleteNodeReq();
        deleteNodeReq.deleteDataNode = (AbstractDeleteDataNode)PlanNodeType.deserialize(transferReq.body);
        deleteNodeReq.version = transferReq.version;
        deleteNodeReq.type = transferReq.type;
        deleteNodeReq.body = transferReq.body;
        deleteNodeReq.commitId = transferReq.commitId;
        deleteNodeReq.dataNodeId = transferReq.dataNodeId;
        deleteNodeReq.consensusGroupId = transferReq.consensusGroupId;
        deleteNodeReq.progressIndex = transferReq.progressIndex;
        return deleteNodeReq;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeConsensusDeleteNodeReq that = (PipeConsensusDeleteNodeReq)((Object)obj);
        return this.deleteDataNode.equals(that.deleteDataNode) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body) && Objects.equals(this.commitId, that.commitId) && Objects.equals(this.consensusGroupId, that.consensusGroupId) && Objects.equals(this.progressIndex, that.progressIndex) && Objects.equals(this.dataNodeId, that.dataNodeId);
    }

    public int hashCode() {
        return Objects.hash(this.deleteDataNode, this.version, this.type, this.body, this.commitId, this.consensusGroupId, this.dataNodeId, this.progressIndex);
    }
}

