/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema.table;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.consensus.request.write.table.CommitDeleteColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.PreDeleteColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.view.CommitDeleteViewColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.view.PreDeleteViewColumnPlan;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.SchemaUtils;
import org.apache.iotdb.confignode.procedure.impl.schema.table.AbstractAlterOrDropTableProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.DropViewColumnProcedure;
import org.apache.iotdb.confignode.procedure.state.schema.DropTableColumnState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteColumnDataReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateColumnCacheReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTableColumnProcedure
extends AbstractAlterOrDropTableProcedure<DropTableColumnState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropTableColumnProcedure.class);
    private String columnName;
    private boolean isAttributeColumn;

    public DropTableColumnProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public DropTableColumnProcedure(String database, String tableName, String queryId, String columnName, boolean isGeneratedByPipe) {
        super(database, tableName, queryId, isGeneratedByPipe);
        this.columnName = columnName;
    }

    @Override
    protected String getActionMessage() {
        return "drop table column";
    }

    /*
     * Exception decompiling
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, DropTableColumnState state) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkAndPreDeleteColumn(ConfigNodeProcedureEnv env) {
        TSStatus status = SchemaUtils.executeInConsensusLayer(this instanceof DropViewColumnProcedure ? new PreDeleteViewColumnPlan(this.database, this.tableName, this.columnName) : new PreDeleteColumnPlan(this.database, this.tableName, this.columnName), env, LOGGER);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.isAttributeColumn = status.isSetMessage();
            this.setNextState(DropTableColumnState.INVALIDATE_CACHE);
        } else {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    private void invalidateCache(ConfigNodeProcedureEnv env) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.INVALIDATE_COLUMN_CACHE, new TInvalidateColumnCacheReq(this.database, this.tableName, this.columnName, this.isAttributeColumn), dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (TSStatus status : statusMap.values()) {
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.error("Failed to invalidate {} column {}'s cache of table {}.{}", new Object[]{this.isAttributeColumn ? "attribute" : "measurement", this.columnName, this.database, this.tableName});
            this.setFailure(new ProcedureException(new MetadataException(String.format("Invalidate column %s cache failed for table %s.%s", this.columnName, this.database, this.tableName))));
            return;
        }
        this.setNextState(this instanceof DropViewColumnProcedure ? DropTableColumnState.DROP_COLUMN : DropTableColumnState.EXECUTE_ON_REGIONS);
    }

    private void executeOnRegions(ConfigNodeProcedureEnv env) {
        Map<TConsensusGroupId, TRegionReplicaSet> relatedRegionGroup;
        Map<TConsensusGroupId, TRegionReplicaSet> map = relatedRegionGroup = this.isAttributeColumn ? env.getConfigManager().getRelatedSchemaRegionGroup4TableModel(this.database) : env.getConfigManager().getRelatedDataRegionGroup4TableModel(this.database);
        if (!relatedRegionGroup.isEmpty()) {
            new AbstractAlterOrDropTableProcedure.TableRegionTaskExecutor<TDeleteColumnDataReq>("delete data for drop table", env, relatedRegionGroup, CnToDnAsyncRequestType.DELETE_COLUMN_DATA, (dataNodeLocation, consensusGroupIdList) -> new TDeleteColumnDataReq(new ArrayList(consensusGroupIdList), this.tableName, this.columnName, this.isAttributeColumn)).execute();
        }
        this.setNextState(DropTableColumnState.DROP_COLUMN);
    }

    private void dropColumn(ConfigNodeProcedureEnv env) {
        TSStatus status = env.getConfigManager().getClusterSchemaManager().executePlan(this instanceof DropViewColumnProcedure ? new CommitDeleteViewColumnPlan(this.database, this.tableName, this.columnName) : new CommitDeleteColumnPlan(this.database, this.tableName, this.columnName), this.isGeneratedByPipe);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    @Override
    protected boolean isRollbackSupported(DropTableColumnState state) {
        return false;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv configNodeProcedureEnv, DropTableColumnState dropTableState) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected DropTableColumnState getState(int stateId) {
        return DropTableColumnState.values()[stateId];
    }

    @Override
    protected int getStateId(DropTableColumnState dropTableColumnState) {
        return dropTableColumnState.ordinal();
    }

    @Override
    protected DropTableColumnState getInitialState() {
        return DropTableColumnState.CHECK_AND_INVALIDATE_COLUMN;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_DROP_TABLE_COLUMN_PROCEDURE.getTypeCode() : ProcedureType.DROP_TABLE_COLUMN_PROCEDURE.getTypeCode());
        this.innerSerialize(stream);
    }

    protected void innerSerialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.columnName, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isAttributeColumn, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.columnName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.isAttributeColumn = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Objects.equals(this.columnName, ((DropTableColumnProcedure)o).columnName) && Objects.equals(this.isAttributeColumn, ((DropTableColumnProcedure)o).isAttributeColumn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.columnName, this.isAttributeColumn);
    }
}

