/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.response.subscription;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.commons.subscription.meta.subscription.SubscriptionMeta;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllSubscriptionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionResp;
import org.apache.iotdb.consensus.common.DataSet;

public class SubscriptionTableResp
implements DataSet {
    private final TSStatus status;
    private final List<SubscriptionMeta> allSubscriptionMeta;
    private final List<ConsumerGroupMeta> allConsumerGroupMeta;

    public SubscriptionTableResp(TSStatus status, List<SubscriptionMeta> allSubscriptionMeta, List<ConsumerGroupMeta> allConsumerGroupMeta) {
        this.status = status;
        this.allSubscriptionMeta = allSubscriptionMeta;
        this.allConsumerGroupMeta = allConsumerGroupMeta;
    }

    public SubscriptionTableResp filter(String topicName, boolean isTableModel) {
        return new SubscriptionTableResp(this.status, this.allSubscriptionMeta.stream().filter(subscriptionMeta -> (Objects.isNull(topicName) || Objects.equals(subscriptionMeta.getTopicMeta().getTopicName(), topicName)) && subscriptionMeta.getTopicMeta().visibleUnder(isTableModel)).collect(Collectors.toList()), this.allConsumerGroupMeta);
    }

    public TShowSubscriptionResp convertToTShowSubscriptionResp() {
        ArrayList<TShowSubscriptionInfo> showSubscriptionInfoList = new ArrayList<TShowSubscriptionInfo>();
        for (SubscriptionMeta subscriptionMeta : this.allSubscriptionMeta) {
            TShowSubscriptionInfo showSubscriptionInfo = new TShowSubscriptionInfo(subscriptionMeta.getTopicMeta().getTopicName(), subscriptionMeta.getConsumerGroupId(), subscriptionMeta.getConsumerIds());
            Optional creationTime = subscriptionMeta.getCreationTime();
            creationTime.ifPresent(arg_0 -> ((TShowSubscriptionInfo)showSubscriptionInfo).setCreationTime(arg_0));
            showSubscriptionInfoList.add(showSubscriptionInfo);
        }
        return new TShowSubscriptionResp(this.status).setSubscriptionInfoList(showSubscriptionInfoList);
    }

    public TGetAllSubscriptionInfoResp convertToTGetAllSubscriptionInfoResp() throws IOException {
        ArrayList<ByteBuffer> subscriptionInfoByteBuffers = new ArrayList<ByteBuffer>();
        for (ConsumerGroupMeta consumerGroupMeta : this.allConsumerGroupMeta) {
            subscriptionInfoByteBuffers.add(consumerGroupMeta.serialize());
        }
        return new TGetAllSubscriptionInfoResp(this.status, subscriptionInfoByteBuffers);
    }
}

