/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.ainode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TAINodeLocation;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class RemoveAINodePlan
extends ConfigPhysicalPlan {
    private TAINodeLocation aiNodeLocation;

    public RemoveAINodePlan() {
        super(ConfigPhysicalPlanType.RemoveAINode);
    }

    public RemoveAINodePlan(TAINodeLocation taiNodeLocation) {
        this();
        this.aiNodeLocation = taiNodeLocation;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ThriftCommonsSerDeUtils.serializeTAINodeLocation((TAINodeLocation)this.aiNodeLocation, (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.aiNodeLocation = ThriftCommonsSerDeUtils.deserializeTAINodeLocation((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoveAINodePlan that = (RemoveAINodePlan)o;
        return this.aiNodeLocation.equals(that.aiNodeLocation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.aiNodeLocation);
    }

    public String toString() {
        return "RemoveAINodePlan{aiNodeLocation=" + this.aiNodeLocation + '}';
    }

    public TAINodeLocation getAINodeLocation() {
        return this.aiNodeLocation;
    }
}

