/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCacheStats;

class CacheStats
implements IDualKeyCacheStats {
    private static final double MEMORY_THRESHOLD_RATIO = 0.8;
    private final long memoryThreshold;
    private final AtomicLong memoryUsage = new AtomicLong(0L);
    private final AtomicLong requestCount = new AtomicLong(0L);
    private final AtomicLong hitCount = new AtomicLong(0L);

    CacheStats(long memoryCapacity) {
        this.memoryThreshold = (long)((double)memoryCapacity * 0.8);
    }

    void increaseMemoryUsage(int size) {
        this.memoryUsage.getAndAdd(size);
    }

    void decreaseMemoryUsage(int size) {
        this.memoryUsage.getAndAdd(-size);
    }

    boolean isExceedMemoryCapacity() {
        return this.memoryUsage.get() > this.memoryThreshold;
    }

    void recordHit(int num) {
        if (this.requestCount.get() < 0L) {
            this.requestCount.set(0L);
            this.hitCount.set(0L);
        }
        this.requestCount.getAndAdd(num);
        this.hitCount.getAndAdd(num);
    }

    void recordMiss(int num) {
        if (this.requestCount.get() < 0L) {
            this.requestCount.set(0L);
            this.hitCount.set(0L);
        }
        this.requestCount.getAndAdd(num);
    }

    @Override
    public long requestCount() {
        return this.requestCount.get();
    }

    @Override
    public long hitCount() {
        return this.hitCount.get();
    }

    @Override
    public double hitRate() {
        long hitCount = this.hitCount.get();
        if (hitCount == 0L) {
            return 0.0;
        }
        long requestCount = this.requestCount.get();
        if (requestCount == 0L) {
            return 0.0;
        }
        return (double)hitCount * 1.0 / (double)requestCount;
    }

    @Override
    public long memoryUsage() {
        return this.memoryUsage.get();
    }

    void reset() {
        this.resetMemoryUsage();
        this.hitCount.set(0L);
        this.requestCount.set(0L);
    }

    void resetMemoryUsage() {
        this.memoryUsage.set(0L);
    }
}

