/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.binary;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.binary.BinaryTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.BooleanColumn;
import org.apache.tsfile.read.common.block.column.BooleanColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public abstract class LogicBinaryTransformer
extends BinaryTransformer {
    private final int count = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber();
    private boolean isLeftDone;
    private boolean isRightDone;

    protected LogicBinaryTransformer(LayerReader leftReader, LayerReader rightReader) {
        super(leftReader, rightReader);
    }

    @Override
    protected void checkType() {
        if (this.leftReaderDataType != TSDataType.BOOLEAN || this.rightReaderDataType != TSDataType.BOOLEAN) {
            throw new UnSupportedDataTypeException("Unsupported data type: " + TSDataType.BOOLEAN);
        }
    }

    @Override
    public YieldableState yieldValue() throws Exception {
        RunLengthEncodedColumn allFalseColumn;
        boolean[] allFalse;
        YieldableState state;
        if (this.leftColumns == null) {
            state = this.leftReader.yield();
            if (state == YieldableState.YIELDABLE) {
                this.leftColumns = this.leftReader.current();
            } else if (state == YieldableState.NOT_YIELDABLE_NO_MORE_DATA) {
                this.isLeftDone = true;
                if (this.isRightDone) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                allFalse = new boolean[1];
                allFalseColumn = new RunLengthEncodedColumn((Column)new BooleanColumn(1, Optional.empty(), allFalse), this.count);
                this.leftColumns = new Column[]{allFalseColumn};
            } else {
                return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
            }
        }
        if (this.rightColumns == null) {
            state = this.rightReader.yield();
            if (state == YieldableState.YIELDABLE) {
                this.rightColumns = this.rightReader.current();
            } else if (state == YieldableState.NOT_YIELDABLE_NO_MORE_DATA) {
                this.isRightDone = true;
                if (this.isLeftDone) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                allFalse = new boolean[1];
                allFalseColumn = new RunLengthEncodedColumn((Column)new BooleanColumn(1, Optional.empty(), allFalse), this.count);
                this.rightColumns = new Column[]{allFalseColumn};
            } else {
                return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
            }
        }
        if (this.isCurrentConstant && this.cachedColumns != null) {
            return YieldableState.YIELDABLE;
        }
        int leftCount = this.leftColumns[0].getPositionCount();
        int rightCount = this.rightColumns[0].getPositionCount();
        int leftRemains = leftCount - this.leftConsumed;
        int rightRemains = rightCount - this.rightConsumed;
        int expectedEntries = Math.min(leftRemains, rightRemains);
        this.cachedColumns = this.mergeAndTransformColumns(expectedEntries);
        return YieldableState.YIELDABLE;
    }

    @Override
    protected Column[] mergeAndTransformColumns(int count) {
        TimeColumnBuilder timeBuilder = new TimeColumnBuilder(null, count);
        BooleanColumnBuilder valueBuilder = new BooleanColumnBuilder(null, count);
        if (this.isLeftReaderConstant || this.isRightReaderConstant) {
            return this.handleConstantColumns((ColumnBuilder)valueBuilder);
        }
        return this.handleNonConstantColumns((ColumnBuilder)timeBuilder, (ColumnBuilder)valueBuilder);
    }

    private Column[] handleNonConstantColumns(ColumnBuilder timeBuilder, ColumnBuilder valueBuilder) {
        Column leftTimes = this.leftColumns[1];
        Column leftValues = this.leftColumns[0];
        Column rightTimes = this.rightColumns[1];
        Column rightValues = this.rightColumns[0];
        int leftEnd = leftTimes.getPositionCount();
        int rightEnd = rightTimes.getPositionCount();
        while (this.leftConsumed < leftEnd && this.rightConsumed < rightEnd) {
            long rightTime;
            long leftTime = leftTimes.getLong(this.leftConsumed);
            if (leftTime != (rightTime = rightTimes.getLong(this.rightConsumed))) {
                if (leftTime < rightTime) {
                    ++this.leftConsumed;
                    continue;
                }
                ++this.rightConsumed;
                continue;
            }
            boolean leftValue = !leftValues.isNull(this.leftConsumed) && leftValues.getBoolean(this.leftConsumed);
            boolean rightValue = !rightValues.isNull(this.rightConsumed) && rightValues.getBoolean(this.rightConsumed);
            boolean result = this.evaluate(leftValue, rightValue);
            valueBuilder.writeBoolean(result);
            ++this.leftConsumed;
            ++this.rightConsumed;
        }
        if (this.leftConsumed == leftEnd) {
            this.leftConsumed = 0;
            if (!this.isLeftDone) {
                this.leftColumns = null;
                this.leftReader.consumedAll();
            }
        }
        if (this.rightConsumed == rightEnd) {
            this.rightConsumed = 0;
            if (!this.isRightDone) {
                this.rightColumns = null;
                this.rightReader.consumedAll();
            }
        }
        Column times = timeBuilder.build();
        Column values = valueBuilder.build();
        return new Column[]{values, times};
    }

    private Column[] handleConstantColumns(ColumnBuilder valueBuilder) {
        if (this.isLeftReaderConstant && this.isRightReaderConstant) {
            boolean leftValue = this.leftColumns[0].getBoolean(0);
            boolean rightValue = this.rightColumns[0].getBoolean(0);
            boolean result = this.evaluate(leftValue, rightValue);
            valueBuilder.writeBoolean(result);
            return new Column[]{valueBuilder.build()};
        }
        if (this.isLeftReaderConstant) {
            for (int i = 0; i < this.rightColumns[0].getPositionCount(); ++i) {
                boolean leftValue = this.leftColumns[0].getBoolean(0);
                boolean rightValue = !this.rightColumns[0].isNull(i) && this.rightColumns[0].getBoolean(i);
                boolean result = this.evaluate(leftValue, rightValue);
                valueBuilder.writeBoolean(result);
            }
            Column times = this.rightColumns[1];
            Column values = valueBuilder.build();
            this.rightColumns = null;
            this.rightReader.consumedAll();
            return new Column[]{values, times};
        }
        if (this.isRightReaderConstant) {
            for (int i = 0; i < this.leftColumns[0].getPositionCount(); ++i) {
                boolean leftValue = !this.leftColumns[0].isNull(0) && this.leftColumns[0].getBoolean(0);
                boolean rightValue = this.rightColumns[0].getBoolean(0);
                boolean result = this.evaluate(leftValue, rightValue);
                valueBuilder.writeBoolean(result);
            }
            Column times = this.leftColumns[1];
            Column values = valueBuilder.build();
            this.leftColumns = null;
            this.leftReader.consumedAll();
            return new Column[]{values, times};
        }
        return null;
    }

    protected abstract boolean evaluate(boolean var1, boolean var2);

    @Override
    protected void transformAndCache(Column leftValues, int leftIndex, Column rightValues, int rightIndex, ColumnBuilder builder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TSDataType[] getDataTypes() {
        return new TSDataType[]{TSDataType.BOOLEAN};
    }
}

