/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util.validation;

import com.google.common.collect.Sets;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.util.validation.CertificateValidationUtil;
import org.eclipse.milo.opcua.stack.core.util.validation.ValidationCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpcUaCertificateUsageChecker
extends PKIXCertPathChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcUaCertificateUsageChecker.class);
    private static final String KEY_USAGE_OID = "2.5.29.15";
    private static final String EXTENDED_KEY_USAGE_OID = "2.5.29.37";
    private final X509Certificate endEntityCert;
    private final CertPath certPath;
    private final Set<ValidationCheck> validationChecks;
    private final boolean endEntityIsClient;

    OpcUaCertificateUsageChecker(CertPath certPath, Set<ValidationCheck> validationChecks, boolean endEntityIsClient) {
        this.certPath = certPath;
        this.validationChecks = validationChecks;
        this.endEntityIsClient = endEntityIsClient;
        this.endEntityCert = (X509Certificate)certPath.getCertificates().get(0);
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("forward checking not supported");
        }
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{KEY_USAGE_OID, EXTENDED_KEY_USAGE_OID}));
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        X509Certificate certificate = (X509Certificate)cert;
        Set<String> criticalExtensions = certificate.getCriticalExtensionOIDs();
        if (criticalExtensions == null) {
            criticalExtensions = Collections.emptySet();
        }
        if (this.endEntityCert.equals(cert)) {
            try {
                CertificateValidationUtil.checkEndEntityKeyUsage((X509Certificate)cert);
                LOGGER.debug("validated KeyUsage for end entity: {}", (Object)((X509Certificate)cert).getSubjectX500Principal().getName());
            }
            catch (UaException e) {
                if (this.validationChecks.contains((Object)ValidationCheck.KEY_USAGE_END_ENTITY) || criticalExtensions.contains(KEY_USAGE_OID)) {
                    throw new CertPathValidatorException(e.getMessage(), e, this.certPath, this.certPath.getCertificates().indexOf(cert), PKIXReason.INVALID_KEY_USAGE);
                }
                LOGGER.warn("check suppressed: certificate failed end-entity usage check: {}", (Object)((X509Certificate)cert).getSubjectX500Principal().getName());
            }
            try {
                CertificateValidationUtil.checkEndEntityExtendedKeyUsage(certificate, this.endEntityIsClient);
                LOGGER.debug("validated ExtendedKeyUsage for end entity: {}", (Object)((X509Certificate)cert).getSubjectX500Principal().getName());
            }
            catch (UaException e) {
                if (this.validationChecks.contains((Object)ValidationCheck.EXTENDED_KEY_USAGE_END_ENTITY) || criticalExtensions.contains(EXTENDED_KEY_USAGE_OID)) {
                    throw new CertPathValidatorException(e.getMessage(), e, this.certPath, this.certPath.getCertificates().indexOf(cert), PKIXReason.INVALID_KEY_USAGE);
                }
                LOGGER.warn("check suppressed: certificate failed end-entity usage check: {}", (Object)((X509Certificate)cert).getSubjectX500Principal().getName());
            }
        }
        if (unresolvedCritExts != null && !unresolvedCritExts.isEmpty()) {
            unresolvedCritExts.remove(KEY_USAGE_OID);
            unresolvedCritExts.remove(EXTENDED_KEY_USAGE_OID);
        }
    }
}

