/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.series;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.query.reader.series.SeriesReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class SeriesRawDataBatchReader
implements ManagedSeriesReader {
    private final SeriesReader seriesReader;
    private boolean hasRemaining;
    private boolean managedByQueryManager;
    private BatchData batchData;
    private boolean hasCachedBatchData = false;

    public SeriesRawDataBatchReader(SeriesReader seriesReader) {
        this.seriesReader = seriesReader;
    }

    public SeriesRawDataBatchReader(PartialPath seriesPath, Set<String> allSensors, TSDataType dataType, QueryContext context, QueryDataSource dataSource, Filter timeFilter, Filter valueFilter, TsFileFilter fileFilter, boolean ascending) {
        this.seriesReader = seriesPath.createSeriesReader(allSensors, dataType, context, dataSource, timeFilter, valueFilter, fileFilter, ascending);
    }

    public SeriesRawDataBatchReader(PartialPath seriesPath, TSDataType dataType, QueryContext context, List<TsFileResource> seqFileResource, List<TsFileResource> unseqFileResource, Filter timeFilter, Filter valueFilter, boolean ascending) {
        HashSet<String> allSensors = new HashSet<String>();
        this.seriesReader = seriesPath.createSeriesReader(allSensors, dataType, context, seqFileResource, unseqFileResource, timeFilter, valueFilter, ascending);
    }

    public boolean hasNextBatch() throws IOException {
        if (this.hasCachedBatchData) {
            return true;
        }
        if (this.readPageData()) {
            this.hasCachedBatchData = true;
            return true;
        }
        if (this.readChunkData()) {
            this.hasCachedBatchData = true;
            return true;
        }
        while (this.seriesReader.hasNextFile()) {
            if (!this.readChunkData()) continue;
            this.hasCachedBatchData = true;
            return true;
        }
        return this.hasCachedBatchData;
    }

    public BatchData nextBatch() throws IOException {
        if (this.hasCachedBatchData || this.hasNextBatch()) {
            this.hasCachedBatchData = false;
            return this.batchData;
        }
        throw new IOException("no next batch");
    }

    public void close() throws IOException {
    }

    @Override
    public boolean isManagedByQueryManager() {
        return this.managedByQueryManager;
    }

    @Override
    public void setManagedByQueryManager(boolean managedByQueryManager) {
        this.managedByQueryManager = managedByQueryManager;
    }

    @Override
    public boolean hasRemaining() {
        return this.hasRemaining;
    }

    @Override
    public void setHasRemaining(boolean hasRemaining) {
        this.hasRemaining = hasRemaining;
    }

    private boolean readChunkData() throws IOException {
        while (this.seriesReader.hasNextChunk()) {
            if (!this.readPageData()) continue;
            return true;
        }
        return false;
    }

    private boolean readPageData() throws IOException {
        while (this.seriesReader.hasNextPage()) {
            this.batchData = this.seriesReader.nextPage();
            if (this.isEmpty(this.batchData)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmpty(BatchData batchData) {
        return batchData == null || !batchData.hasCurrent();
    }

    public SeriesReader getSeriesReader() {
        return this.seriesReader;
    }
}

