/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.query.dataset.IUDFInputDataSet;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class UDFInputDataSet
implements IUDFInputDataSet {
    private final QueryDataSet dataSet;
    private List<TSDataType> dataTypes;

    public UDFInputDataSet(QueryDataSet dataSet, List<TSDataType> dataTypes) {
        this.dataSet = dataSet;
        this.dataTypes = dataTypes;
    }

    @Override
    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    @Override
    public boolean hasNextRowInObjects() throws IOException {
        return this.dataSet.hasNextWithoutConstraint();
    }

    @Override
    public Object[] nextRowInObjects() throws IOException {
        Object[] nextRow = new Object[this.dataSet.getColumnNum() + 1];
        RowRecord r = this.dataSet.nextWithoutConstraint();
        for (int i = 0; i < this.dataSet.getColumnNum(); ++i) {
            Field f = (Field)r.getFields().get(i);
            if (f == null) continue;
            nextRow[i] = f.getObjectValue(f.getDataType());
        }
        nextRow[this.dataSet.getColumnNum()] = r.getTimestamp();
        return nextRow;
    }
}

