/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.utils.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.engine.compaction.TsFileIdentifier;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;

public class CompactionLogger
implements AutoCloseable {
    public static final String CROSS_COMPACTION_LOG_NAME_SUFFIX = ".cross-compaction.log";
    public static final String CROSS_COMPACTION_LOG_NAME_FROM_OLD = "merge.log";
    public static final String INNER_COMPACTION_LOG_NAME_SUFFIX = ".inner-compaction.log";
    public static final String INNER_COMPACTION_LOG_NAME_SUFFIX_FROM_OLD = ".compaction.log";
    public static final String STR_SOURCE_FILES = "source";
    public static final String STR_TARGET_FILES = "target";
    public static final String STR_SOURCE_FILES_FROM_OLD = "info-source";
    public static final String STR_TARGET_FILES_FROM_OLD = "info-target";
    public static final String STR_SEQ_FILES_FROM_OLD = "seqFiles";
    public static final String STR_UNSEQ_FILES_FROM_OLD = "unseqFiles";
    public static final String SEQUENCE_NAME_FROM_OLD = "sequence";
    public static final String UNSEQUENCE_NAME_FROM_OLD = "unsequence";
    public static final String STR_MERGE_START_FROM_OLD = "merge start";
    private BufferedWriter logStream;

    public CompactionLogger(File logFile) throws IOException {
        this.logStream = new BufferedWriter(new FileWriter(logFile, true));
    }

    @Override
    public void close() throws IOException {
        this.logStream.close();
    }

    public void logFiles(List<TsFileResource> tsFiles, String flag) throws IOException {
        for (TsFileResource tsFileResource : tsFiles) {
            this.logStream.write(flag + " " + TsFileIdentifier.getFileIdentifierFromFilePath(tsFileResource.getTsFile().getAbsolutePath()).toString());
            this.logStream.newLine();
        }
        this.logStream.flush();
    }

    public static File[] findCompactionLogs(boolean isInnerSpace, String directory) {
        String compactionLogSuffix = isInnerSpace ? INNER_COMPACTION_LOG_NAME_SUFFIX : CROSS_COMPACTION_LOG_NAME_SUFFIX;
        File timePartitionDir = new File(directory);
        if (timePartitionDir.exists()) {
            return timePartitionDir.listFiles((dir, name) -> name.endsWith(compactionLogSuffix));
        }
        return new File[0];
    }
}

