/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaResp;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.VectorMeasurementSchema;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullMeasurementSchemaHandler
implements AsyncMethodCallback<PullSchemaResp> {
    private static final Logger logger = LoggerFactory.getLogger(PullMeasurementSchemaHandler.class);
    private Node owner;
    private List<String> prefixPaths;
    private AtomicReference<List<IMeasurementSchema>> timeseriesSchemas;

    public PullMeasurementSchemaHandler(Node owner, List<String> prefixPaths, AtomicReference<List<IMeasurementSchema>> timeseriesSchemas) {
        this.owner = owner;
        this.prefixPaths = prefixPaths;
        this.timeseriesSchemas = timeseriesSchemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(PullSchemaResp response) {
        ByteBuffer buffer = response.schemaBytes;
        int size = buffer.getInt();
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>(size);
        for (int i = 0; i < size; ++i) {
            schemas.add((MeasurementSchema)(buffer.get() == 0 ? MeasurementSchema.partialDeserializeFrom((ByteBuffer)buffer) : VectorMeasurementSchema.partialDeserializeFrom((ByteBuffer)buffer)));
        }
        AtomicReference<List<IMeasurementSchema>> atomicReference = this.timeseriesSchemas;
        synchronized (atomicReference) {
            this.timeseriesSchemas.set(schemas);
            this.timeseriesSchemas.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Exception exception) {
        logger.error("Cannot pull time series schema of {} from {}", new Object[]{this.prefixPaths, this.owner, exception});
        AtomicReference<List<IMeasurementSchema>> atomicReference = this.timeseriesSchemas;
        synchronized (atomicReference) {
            this.timeseriesSchemas.notifyAll();
        }
    }
}

