/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.clusterinfo;

import org.apache.iotdb.cluster.config.ClusterConfig;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.ClusterInfoService;
import org.apache.iotdb.cluster.server.clusterinfo.ClusterInfoServerMBean;
import org.apache.iotdb.cluster.server.clusterinfo.ClusterInfoServiceImpl;
import org.apache.iotdb.cluster.server.clusterinfo.ClusterInfoServiceThriftHandler;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.runtime.RPCServiceException;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.service.thrift.ThriftService;
import org.apache.iotdb.db.service.thrift.ThriftServiceThread;
import org.apache.thrift.server.TServerEventHandler;

public class ClusterInfoServer
extends ThriftService
implements ClusterInfoServerMBean {
    private ClusterInfoServiceImpl serviceImpl;

    public static ClusterInfoServer getInstance() {
        return ClusterMonitorServiceHolder.INSTANCE;
    }

    public ServiceType getID() {
        return ServiceType.CLUSTER_INFO_SERVICE;
    }

    public ThriftService getImplementation() {
        return ClusterInfoServer.getInstance();
    }

    public void initTProcessor() {
        this.initSyncedServiceImpl(null);
        this.serviceImpl = new ClusterInfoServiceImpl();
        this.processor = new ClusterInfoService.Processor((ClusterInfoService.Iface)this.serviceImpl);
    }

    public void initThriftServiceThread() throws IllegalAccessException {
        ClusterConfig clusterConfig = ClusterDescriptor.getInstance().getConfig();
        IoTDBConfig nodeConfig = IoTDBDescriptor.getInstance().getConfig();
        try {
            this.thriftServiceThread = new ThriftServiceThread(this.processor, this.getID().getName(), ThreadName.CLUSTER_INFO_SERVICE.getName(), nodeConfig.getRpcAddress(), clusterConfig.getClusterInfoRpcPort(), nodeConfig.getRpcMaxConcurrentClientNum(), nodeConfig.getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new ClusterInfoServiceThriftHandler(this.serviceImpl), IoTDBDescriptor.getInstance().getConfig().isRpcThriftCompressionEnable());
        }
        catch (RPCServiceException e) {
            throw new IllegalAccessException(e.getMessage());
        }
        this.thriftServiceThread.setName(ThreadName.CLUSTER_INFO_SERVICE.getName() + "Service");
    }

    public String getBindIP() {
        return IoTDBDescriptor.getInstance().getConfig().getRpcAddress();
    }

    public int getBindPort() {
        return ClusterDescriptor.getInstance().getConfig().getClusterInfoRpcPort();
    }

    private static class ClusterMonitorServiceHolder {
        private static final ClusterInfoServer INSTANCE = new ClusterInfoServer();

        private ClusterMonitorServiceHolder() {
        }
    }
}

