/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.fill;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.cluster.ClusterIoTDB;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.QueryTimeOutException;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.query.fill.PreviousFillArguments;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PreviousFillRequest;
import org.apache.iotdb.cluster.server.handlers.caller.PreviousFillHandler;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.db.utils.TimeValuePairUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterPreviousFill
extends PreviousFill {
    private static final Logger logger = LoggerFactory.getLogger(ClusterPreviousFill.class);
    private MetaGroupMember metaGroupMember;
    private TimeValuePair fillResult;
    private static final String PREVIOUS_FILL_EXCEPTION_LOGGER_FORMAT = "{}: Cannot perform previous fill of {} to {}";

    ClusterPreviousFill(PreviousFill fill, MetaGroupMember metaGroupMember) {
        super(fill.getDataType(), fill.getQueryStartTime(), fill.getBeforeRange());
        this.metaGroupMember = metaGroupMember;
    }

    ClusterPreviousFill(TSDataType dataType, long queryTime, long beforeRange, MetaGroupMember metaGroupMember) {
        super(dataType, queryTime, beforeRange);
        this.metaGroupMember = metaGroupMember;
    }

    public void configureFill(PartialPath path, TSDataType dataType, long queryTime, Set<String> deviceMeasurements, QueryContext context) throws QueryProcessException, StorageEngineException {
        this.fillResult = this.performPreviousFill(path, dataType, queryTime, this.getBeforeRange(), deviceMeasurements, context);
    }

    public TimeValuePair getFillResult() {
        return this.fillResult;
    }

    private TimeValuePair performPreviousFill(PartialPath path, TSDataType dataType, long queryTime, long beforeRange, Set<String> deviceMeasurements, QueryContext context) throws StorageEngineException, QueryProcessException {
        try {
            this.metaGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new StorageEngineException((Throwable)e);
        }
        TimeValuePairUtils.Intervals intervals = new TimeValuePairUtils.Intervals();
        long lowerBound = beforeRange == -1L ? Long.MIN_VALUE : queryTime - beforeRange;
        intervals.addInterval(lowerBound, queryTime);
        List<PartitionGroup> partitionGroups = this.metaGroupMember.routeIntervals(intervals, path);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending data query of {} to {} groups", new Object[]{this.metaGroupMember.getName(), path, partitionGroups.size()});
        }
        CountDownLatch latch = new CountDownLatch(partitionGroups.size());
        PreviousFillHandler handler = new PreviousFillHandler(latch);
        ExecutorService fillService = Executors.newFixedThreadPool(partitionGroups.size());
        PreviousFillArguments arguments = new PreviousFillArguments(path, dataType, queryTime, beforeRange, deviceMeasurements);
        for (PartitionGroup partitionGroup : partitionGroups) {
            fillService.submit(() -> this.performPreviousFill(arguments, context, partitionGroup, handler));
        }
        fillService.shutdown();
        try {
            boolean terminated = fillService.awaitTermination(ClusterConstant.getReadOperationTimeoutMS(), TimeUnit.MILLISECONDS);
            if (!terminated) {
                logger.warn("Executor service termination timed out");
            }
        }
        catch (InterruptedException e) {
            throw new QueryProcessException(e.getMessage());
        }
        return handler.getResult();
    }

    private void performPreviousFill(PreviousFillArguments arguments, QueryContext context, PartitionGroup group, PreviousFillHandler fillHandler) {
        if (group.contains(this.metaGroupMember.getThisNode())) {
            this.localPreviousFill(arguments, context, group, fillHandler);
        } else {
            this.remotePreviousFill(arguments, context, group, fillHandler);
        }
    }

    private void localPreviousFill(PreviousFillArguments arguments, QueryContext context, PartitionGroup group, PreviousFillHandler fillHandler) {
        DataGroupMember localDataMember = this.metaGroupMember.getLocalDataMember(group.getHeader(), group.getRaftId());
        try {
            fillHandler.onComplete(localDataMember.getLocalQueryExecutor().localPreviousFill(arguments.getPath(), arguments.getDataType(), arguments.getQueryTime(), arguments.getBeforeRange(), arguments.getDeviceMeasurements(), context));
        }
        catch (IOException | StorageEngineException | QueryProcessException e) {
            fillHandler.onError((Exception)e);
        }
    }

    private void remotePreviousFill(PreviousFillArguments arguments, QueryContext context, PartitionGroup group, PreviousFillHandler fillHandler) {
        PreviousFillRequest request = new PreviousFillRequest(arguments.getPath().getFullPath(), arguments.getQueryTime(), arguments.getBeforeRange(), context.getQueryId(), this.metaGroupMember.getThisNode(), group.getHeader(), arguments.getDataType().ordinal(), arguments.getDeviceMeasurements());
        for (Node node : group) {
            ByteBuffer byteBuffer = ClusterDescriptor.getInstance().getConfig().isUseAsyncServer() ? this.remoteAsyncPreviousFill(node, request, arguments) : this.remoteSyncPreviousFill(node, request, arguments);
            if (byteBuffer == null) continue;
            fillHandler.onComplete(byteBuffer);
            return;
        }
        fillHandler.onError(new QueryTimeOutException(String.format("PreviousFill %s@%d range: %d", arguments.getPath().getFullPath(), arguments.getQueryTime(), arguments.getBeforeRange())));
    }

    private ByteBuffer remoteAsyncPreviousFill(Node node, PreviousFillRequest request, PreviousFillArguments arguments) {
        ByteBuffer byteBuffer = null;
        try {
            AsyncDataClient asyncDataClient = ClusterIoTDB.getInstance().getAsyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
            byteBuffer = SyncClientAdaptor.previousFill(asyncDataClient, request);
        }
        catch (IOException e) {
            logger.warn("{}: Cannot connect to {} during previous fill", (Object)this.metaGroupMember, (Object)node);
        }
        catch (Exception e) {
            logger.error(PREVIOUS_FILL_EXCEPTION_LOGGER_FORMAT, new Object[]{this.metaGroupMember, arguments.getPath(), node, e});
        }
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer remoteSyncPreviousFill(Node node, PreviousFillRequest request, PreviousFillArguments arguments) {
        ByteBuffer byteBuffer = null;
        SyncDataClient syncDataClient = null;
        try {
            syncDataClient = ClusterIoTDB.getInstance().getSyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
            byteBuffer = syncDataClient.previousFill(request);
        }
        catch (TException e) {
            syncDataClient.close();
            logger.error(PREVIOUS_FILL_EXCEPTION_LOGGER_FORMAT, new Object[]{this.metaGroupMember.getName(), arguments.getPath(), node, e});
        }
        catch (Exception e) {
            logger.error(PREVIOUS_FILL_EXCEPTION_LOGGER_FORMAT, new Object[]{this.metaGroupMember.getName(), arguments.getPath(), node, e});
        }
        finally {
            if (syncDataClient != null) {
                syncDataClient.returnSelf();
            }
        }
        return byteBuffer;
    }
}

