/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.metadata;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.cluster.ClusterIoTDB;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.query.manage.QueryCoordinator;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaResp;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.utils.ClusterUtils;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.TimeseriesSchema;
import org.apache.iotdb.tsfile.write.schema.VectorMeasurementSchema;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaPuller {
    private static final Logger logger = LoggerFactory.getLogger(MetaPuller.class);
    private MetaGroupMember metaGroupMember;

    private MetaPuller() {
    }

    public void init(MetaGroupMember metaGroupMember) {
        this.metaGroupMember = metaGroupMember;
    }

    public static MetaPuller getInstance() {
        return MetaPullerHolder.INSTANCE;
    }

    List<IMeasurementSchema> pullMeasurementSchemas(List<PartialPath> prefixPaths) throws MetadataException {
        logger.debug("{}: Pulling timeseries schemas of {}", (Object)this.metaGroupMember.getName(), prefixPaths);
        HashMap<PartitionGroup, List> partitionGroupPathMap = new HashMap<PartitionGroup, List>();
        for (PartialPath prefixPath : prefixPaths) {
            PartitionGroup partitionGroup = ClusterUtils.partitionByPathTimeWithSync(prefixPath, this.metaGroupMember);
            partitionGroupPathMap.computeIfAbsent(partitionGroup, g -> new ArrayList()).add(prefixPath);
        }
        ArrayList<IMeasurementSchema> schemas = new ArrayList<IMeasurementSchema>();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: pulling schemas of {} and other {} paths from {} groups", new Object[]{this.metaGroupMember.getName(), prefixPaths.get(0), prefixPaths.size() - 1, partitionGroupPathMap.size()});
        }
        for (Map.Entry partitionGroupListEntry : partitionGroupPathMap.entrySet()) {
            PartitionGroup partitionGroup = (PartitionGroup)partitionGroupListEntry.getKey();
            List paths = (List)partitionGroupListEntry.getValue();
            this.pullMeasurementSchemas(partitionGroup, paths, schemas);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: pulled {} schemas for {} and other {} paths", new Object[]{this.metaGroupMember.getName(), schemas.size(), prefixPaths.get(0), prefixPaths.size() - 1});
        }
        return schemas;
    }

    public void pullMeasurementSchemas(PartitionGroup partitionGroup, List<PartialPath> prefixPaths, List<IMeasurementSchema> results) {
        Node node;
        if (partitionGroup.contains(this.metaGroupMember.getThisNode())) {
            try {
                this.metaGroupMember.getLocalDataMember(partitionGroup.getHeader(), "Pull timeseries of " + prefixPaths).syncLeader(null);
            }
            catch (CheckConsistencyException e) {
                logger.warn("Failed to check consistency.", (Throwable)e);
            }
            int preSize = results.size();
            for (PartialPath prefixPath : prefixPaths) {
                IoTDB.metaManager.collectMeasurementSchema(prefixPath, results);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Pulled {} timeseries schemas of {} and other {} paths from local", new Object[]{this.metaGroupMember.getName(), results.size() - preSize, prefixPaths.get(0), prefixPaths.size() - 1});
            }
            return;
        }
        PullSchemaRequest pullSchemaRequest = new PullSchemaRequest();
        pullSchemaRequest.setHeader(partitionGroup.getHeader());
        pullSchemaRequest.setPrefixPaths(prefixPaths.stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
        Iterator iterator = partitionGroup.iterator();
        while (iterator.hasNext() && !this.pullMeasurementSchemas(node = (Node)iterator.next(), pullSchemaRequest, results)) {
        }
    }

    private boolean pullMeasurementSchemas(Node node, PullSchemaRequest request, List<IMeasurementSchema> results) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Pulling timeseries schemas of {} and other {} paths from {}", new Object[]{this.metaGroupMember.getName(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node});
        }
        List<IMeasurementSchema> schemas = null;
        try {
            schemas = this.pullMeasurementSchemas(node, request);
        }
        catch (IOException | TException e) {
            logger.error("{}: Cannot pull timeseries schemas of {} and other {} paths from {}", new Object[]{this.metaGroupMember.getName(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node, e});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("{}: Cannot pull timeseries schemas of {} and other {} paths from {}", new Object[]{this.metaGroupMember.getName(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node, e});
        }
        if (schemas != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Pulled {} timeseries schemas of {} and other {} paths from {} of {}", new Object[]{this.metaGroupMember.getName(), schemas.size(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node, request.getHeader()});
            }
            results.addAll(schemas);
            return true;
        }
        return false;
    }

    private List<IMeasurementSchema> pullMeasurementSchemas(Node node, PullSchemaRequest request) throws IOException, TException, InterruptedException {
        List<IMeasurementSchema> schemas;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = ClusterIoTDB.getInstance().getAsyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
            schemas = SyncClientAdaptor.pullMeasurementSchema(client, request);
        } else {
            SyncDataClient syncDataClient = null;
            try {
                syncDataClient = ClusterIoTDB.getInstance().getSyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
                PullSchemaResp pullSchemaResp = syncDataClient.pullMeasurementSchema(request);
                ByteBuffer buffer = pullSchemaResp.schemaBytes;
                int size = buffer.getInt();
                schemas = new ArrayList<IMeasurementSchema>(size);
                for (int i = 0; i < size; ++i) {
                    schemas.add((IMeasurementSchema)(buffer.get() == 0 ? MeasurementSchema.partialDeserializeFrom((ByteBuffer)buffer) : VectorMeasurementSchema.partialDeserializeFrom((ByteBuffer)buffer)));
                }
            }
            catch (TException e) {
                syncDataClient.close();
                throw e;
            }
            finally {
                if (syncDataClient != null) {
                    syncDataClient.returnSelf();
                }
            }
        }
        return schemas;
    }

    public void pullTimeSeriesSchemas(List<PartialPath> prefixPaths, RaftNode ignoredGroup) throws MetadataException {
        PartitionGroup partitionGroup;
        HashSet<PartialPath> prefixPathSet = new HashSet<PartialPath>(prefixPaths);
        ArrayList<PartialPath> uniquePrefixPaths = new ArrayList<PartialPath>(prefixPathSet);
        logger.debug("{}: Pulling timeseries schemas of {}, ignored group {}", new Object[]{this.metaGroupMember.getName(), uniquePrefixPaths, ignoredGroup});
        HashMap<PartitionGroup, List> partitionGroupPathMap = new HashMap<PartitionGroup, List>();
        for (PartialPath partialPath : uniquePrefixPaths) {
            if ("time".equalsIgnoreCase(partialPath.getFullPath()) || (partitionGroup = ClusterUtils.partitionByPathTimeWithSync(partialPath, this.metaGroupMember)).getHeader().equals(ignoredGroup)) continue;
            partitionGroupPathMap.computeIfAbsent(partitionGroup, g -> new ArrayList()).add(partialPath.getFullPath());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: pulling schemas of {} and other {} paths from {} groups", new Object[]{this.metaGroupMember.getName(), uniquePrefixPaths.get(0), uniquePrefixPaths.size() - 1, partitionGroupPathMap.size()});
        }
        for (Map.Entry entry : partitionGroupPathMap.entrySet()) {
            partitionGroup = (PartitionGroup)entry.getKey();
            List paths = (List)entry.getValue();
            this.pullTimeSeriesSchemas(partitionGroup, paths, null);
        }
    }

    public void pullTimeSeriesSchemas(PartitionGroup partitionGroup, List<String> prefixPaths, List<TimeseriesSchema> timeseriesSchemas) {
        if (partitionGroup.contains(this.metaGroupMember.getThisNode())) {
            try {
                this.metaGroupMember.getLocalDataMember(partitionGroup.getHeader(), "Pull timeseries of " + prefixPaths).syncLeader(null);
            }
            catch (CheckConsistencyException e) {
                logger.warn("Failed to check consistency.", (Throwable)e);
            }
            return;
        }
        PullSchemaRequest pullSchemaRequest = new PullSchemaRequest();
        pullSchemaRequest.setHeader(partitionGroup.getHeader());
        pullSchemaRequest.setPrefixPaths(prefixPaths);
        List<Node> nodes = QueryCoordinator.getINSTANCE().reorderNodes(partitionGroup);
        for (Node node : nodes) {
            if (this.tryPullTimeSeriesSchemas(node, pullSchemaRequest, timeseriesSchemas)) break;
        }
    }

    private boolean tryPullTimeSeriesSchemas(Node node, PullSchemaRequest request, List<TimeseriesSchema> timeseriesSchemas) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Pulling timeseries schemas of {} and other {} paths from {}", new Object[]{this.metaGroupMember.getName(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node});
        }
        List<TimeseriesSchema> schemas = null;
        try {
            schemas = this.pullTimeSeriesSchemas(node, request);
        }
        catch (IOException | TException e) {
            logger.error("{}: Cannot pull timeseries schemas of {} and other {} paths from {}", new Object[]{this.metaGroupMember.getName(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node, e});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("{}: Cannot pull timeseries schemas of {} and other {} paths from {}", new Object[]{this.metaGroupMember.getName(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node, e});
        }
        if (schemas != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Pulled {} timeseries schemas of {} and other {} paths from {} of {}", new Object[]{this.metaGroupMember.getName(), schemas.size(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node, request.getHeader()});
            }
            if (timeseriesSchemas == null) {
                for (TimeseriesSchema schema : schemas) {
                    SchemaUtils.cacheTimeseriesSchema((TimeseriesSchema)schema);
                }
            } else {
                timeseriesSchemas.addAll(schemas);
            }
            return true;
        }
        return false;
    }

    private List<TimeseriesSchema> pullTimeSeriesSchemas(Node node, PullSchemaRequest request) throws IOException, TException, InterruptedException {
        List<TimeseriesSchema> schemas;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = ClusterIoTDB.getInstance().getAsyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
            schemas = SyncClientAdaptor.pullTimeseriesSchema(client, request);
        } else {
            SyncDataClient syncDataClient = null;
            try {
                syncDataClient = ClusterIoTDB.getInstance().getSyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
                PullSchemaResp pullSchemaResp = syncDataClient.pullTimeSeriesSchema(request);
                ByteBuffer buffer = pullSchemaResp.schemaBytes;
                int size = buffer.getInt();
                schemas = new ArrayList<TimeseriesSchema>(size);
                for (int i = 0; i < size; ++i) {
                    schemas.add(TimeseriesSchema.deserializeFrom((ByteBuffer)buffer));
                }
            }
            catch (TException e) {
                syncDataClient.close();
                throw e;
            }
            finally {
                if (syncDataClient != null) {
                    syncDataClient.returnSelf();
                }
            }
        }
        return schemas;
    }

    private static class MetaPullerHolder {
        private static final MetaPuller INSTANCE = new MetaPuller();

        private MetaPullerHolder() {
        }
    }
}

