/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.type;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.iotdb.metrics.type.IMetric;

public interface HistogramSnapshot
extends IMetric {
    public double getValue(double var1);

    public long[] getValues();

    public int size();

    public long getMin();

    public double getMedian();

    public double getMean();

    public long getMax();

    public void dump(OutputStream var1);

    @Override
    default public void constructValueMap(Map<String, Object> result) {
        result.put("max", this.getMax());
        result.put("sum", Arrays.stream(this.getValues()).sum());
        result.put("p0", this.getValue(0.0));
        result.put("p25", this.getValue(0.25));
        result.put("p50", this.getValue(0.5));
        result.put("p75", this.getValue(0.75));
        result.put("p100", this.getValue(1.0));
    }
}

