/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCatchUpHandler
implements AsyncMethodCallback<Long> {
    private static final Logger logger = LoggerFactory.getLogger(LogCatchUpHandler.class);
    private Node follower;
    private Log log;
    private AtomicBoolean appendSucceed;
    private String memberName;
    private RaftMember raftMember;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(Long response) {
        logger.debug("{}: Received a catch-up result of {} from {}", new Object[]{this.memberName, this.log, this.follower});
        long resp = response;
        if (resp == -1L) {
            AtomicBoolean atomicBoolean = this.appendSucceed;
            synchronized (atomicBoolean) {
                this.appendSucceed.set(true);
                this.appendSucceed.notifyAll();
            }
            logger.debug("{}: Succeeded to send log {}", (Object)this.memberName, (Object)this.log);
        } else {
            if (resp == -2L) {
                logger.debug("{}: Log mismatch occurred when sending log {}", (Object)this.memberName, (Object)this.log);
                AtomicBoolean atomicBoolean = this.appendSucceed;
                synchronized (atomicBoolean) {
                    this.appendSucceed.set(true);
                    this.appendSucceed.notifyAll();
                }
            }
            if (resp == -13L) {
                logger.info("{}: Catchup task rejected by receiver {}", (Object)this.memberName, (Object)this.follower);
                AtomicBoolean atomicBoolean = this.appendSucceed;
                synchronized (atomicBoolean) {
                    this.appendSucceed.set(false);
                    this.appendSucceed.notifyAll();
                }
            }
            logger.debug("{}: Received a rejection because term is updated to: {}", (Object)this.memberName, (Object)resp);
            this.raftMember.stepDown(resp, false);
            AtomicBoolean atomicBoolean = this.appendSucceed;
            synchronized (atomicBoolean) {
                this.appendSucceed.notifyAll();
            }
            logger.warn("{}: Catch-up aborted because leadership is lost", (Object)this.memberName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Exception exception) {
        AtomicBoolean atomicBoolean = this.appendSucceed;
        synchronized (atomicBoolean) {
            this.appendSucceed.notifyAll();
        }
        logger.warn("{}: Catch-up fails when sending log {}", new Object[]{this.memberName, this.log, exception});
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setAppendSucceed(AtomicBoolean appendSucceed) {
        this.appendSucceed = appendSucceed;
    }

    public void setRaftMember(RaftMember raftMember) {
        this.raftMember = raftMember;
        this.memberName = raftMember.getName();
    }

    public void setFollower(Node follower) {
        this.follower = follower;
    }

    public AtomicBoolean getAppendSucceed() {
        return this.appendSucceed;
    }
}

