/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.logtypes;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.db.utils.SerializeUtils;

public class CloseFileLog
extends Log {
    private String storageGroupName;
    private boolean isSeq;
    private long partitionId;

    public CloseFileLog() {
    }

    public CloseFileLog(String storageGroupName, long partitionId, boolean isSeq) {
        this.storageGroupName = storageGroupName;
        this.isSeq = isSeq;
        this.partitionId = partitionId;
    }

    @Override
    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            dataOutputStream.writeByte((byte)Log.Types.CLOSE_FILE.ordinal());
            dataOutputStream.writeLong(this.getCurrLogIndex());
            dataOutputStream.writeLong(this.getCurrLogTerm());
            SerializeUtils.serialize((String)this.storageGroupName, (DataOutputStream)dataOutputStream);
            dataOutputStream.writeBoolean(this.isSeq);
            dataOutputStream.writeLong(this.partitionId);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.setCurrLogIndex(buffer.getLong());
        this.setCurrLogTerm(buffer.getLong());
        this.storageGroupName = SerializeUtils.deserializeString((ByteBuffer)buffer);
        this.isSeq = buffer.get() == 1;
        this.partitionId = buffer.getLong();
    }

    public boolean isSeq() {
        return this.isSeq;
    }

    public String getStorageGroupName() {
        return this.storageGroupName;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public String toString() {
        return "CloseFileLog{storageGroupName='" + this.storageGroupName + '\'' + ", isSeq=" + this.isSeq + ", partitionId=" + this.partitionId + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloseFileLog that = (CloseFileLog)o;
        return this.isSeq == that.isSeq && Objects.equals(this.storageGroupName, that.storageGroupName) && this.partitionId == that.partitionId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.storageGroupName, this.partitionId, this.isSeq);
    }
}

