/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.access;

import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.access.RowIterator;
import org.apache.iotdb.db.query.udf.api.access.RowWindow;
import org.apache.iotdb.db.query.udf.core.access.ElasticSerializableTVListBackedSingleColumnRow;
import org.apache.iotdb.db.query.udf.core.access.ElasticSerializableTVListBackedSingleColumnWindowIterator;
import org.apache.iotdb.db.query.udf.core.access.EmptyRowIterator;
import org.apache.iotdb.db.query.udf.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class ElasticSerializableTVListBackedSingleColumnWindow
implements RowWindow {
    private final ElasticSerializableTVList tvList;
    private int beginIndex;
    private int endIndex;
    private int size;
    private long startTime;
    private long endTime;
    private final ElasticSerializableTVListBackedSingleColumnRow row;
    private ElasticSerializableTVListBackedSingleColumnWindowIterator rowIterator;

    public ElasticSerializableTVListBackedSingleColumnWindow(ElasticSerializableTVList tvList) {
        this.tvList = tvList;
        this.beginIndex = 0;
        this.endIndex = 0;
        this.size = 0;
        this.row = new ElasticSerializableTVListBackedSingleColumnRow(tvList, this.beginIndex);
    }

    @Override
    public int windowSize() {
        return this.size;
    }

    @Override
    public Row getRow(int rowIndex) {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("Size is 0");
        }
        return this.row.seek(this.beginIndex + rowIndex);
    }

    @Override
    public TSDataType getDataType(int columnIndex) {
        return this.tvList.getDataType();
    }

    @Override
    public RowIterator getRowIterator() {
        if (this.size == 0) {
            return new EmptyRowIterator();
        }
        if (this.rowIterator == null) {
            this.rowIterator = new ElasticSerializableTVListBackedSingleColumnWindowIterator(this.tvList, this.beginIndex, this.endIndex);
        }
        this.rowIterator.reset();
        return this.rowIterator;
    }

    public void setEmptyWindow(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.size = 0;
    }

    @Override
    public long windowStartTime() {
        return this.startTime;
    }

    @Override
    public long windowEndTime() {
        return this.endTime;
    }

    public void seek(int beginIndex, int endIndex, long startTime, long endTime) {
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.size = endIndex - beginIndex;
        this.startTime = startTime;
        this.endTime = endTime;
        this.row.seek(beginIndex);
        this.rowIterator = null;
    }
}

