/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.operator;

import java.time.ZoneId;
import org.apache.iotdb.db.protocol.influxdb.constant.InfluxSQLConstant;
import org.apache.iotdb.db.qp.logical.crud.SelectComponent;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.expression.ResultColumn;
import org.apache.iotdb.db.query.expression.unary.FunctionExpression;
import org.apache.iotdb.db.query.expression.unary.TimeSeriesOperand;

public final class InfluxSelectComponent
extends SelectComponent {
    private boolean hasAggregationFunction = false;
    private boolean hasSelectorFunction = false;
    private boolean hasMoreSelectorFunction = false;
    private boolean hasMoreFunction = false;
    private boolean hasFunction = false;
    private boolean hasCommonQuery = false;

    public InfluxSelectComponent() {
        super((ZoneId)null);
    }

    @Override
    public void addResultColumn(ResultColumn resultColumn) {
        Expression expression = resultColumn.getExpression();
        if (expression instanceof FunctionExpression) {
            String functionName = ((FunctionExpression)expression).getFunctionName();
            if (InfluxSQLConstant.getNativeFunctionNames().contains(functionName.toLowerCase())) {
                if (this.hasFunction) {
                    this.hasMoreFunction = true;
                } else {
                    this.hasFunction = true;
                }
            }
            if (InfluxSQLConstant.getNativeSelectorFunctionNames().contains(functionName.toLowerCase())) {
                if (this.hasSelectorFunction) {
                    this.hasMoreSelectorFunction = true;
                } else {
                    this.hasSelectorFunction = true;
                }
            } else {
                this.hasAggregationFunction = true;
            }
        }
        if (expression instanceof TimeSeriesOperand) {
            this.hasCommonQuery = true;
        }
        this.resultColumns.add(resultColumn);
    }

    public boolean isHasAggregationFunction() {
        return this.hasAggregationFunction;
    }

    public boolean isHasMoreFunction() {
        return this.hasMoreFunction;
    }

    public boolean isHasCommonQuery() {
        return this.hasCommonQuery;
    }

    public boolean isHasSelectorFunction() {
        return this.hasSelectorFunction;
    }

    public boolean isHasMoreSelectorFunction() {
        return this.hasMoreSelectorFunction;
    }

    public boolean isHasFunction() {
        return this.hasFunction;
    }
}

