/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable.entry;

import java.util.function.Function;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.idtable.entry.PlainDeviceID;
import org.apache.iotdb.db.metadata.idtable.entry.SHA256DeviceID;
import org.apache.iotdb.db.metadata.path.PartialPath;

public class DeviceIDFactory {
    Function<String, IDeviceID> getDeviceIDFunction = IoTDBDescriptor.getInstance().getConfig().isEnableIDTable() && IoTDBDescriptor.getInstance().getConfig().getDeviceIDTransformationMethod().equals("SHA256") ? SHA256DeviceID::new : PlainDeviceID::new;

    public static DeviceIDFactory getInstance() {
        return DeviceIDFactoryHolder.INSTANCE;
    }

    private DeviceIDFactory() {
    }

    public IDeviceID getDeviceID(PartialPath devicePath) {
        return this.getDeviceIDFunction.apply(devicePath.toString());
    }

    public IDeviceID getDeviceID(String devicePath) {
        return this.getDeviceIDFunction.apply(devicePath);
    }

    public void reset() {
        this.getDeviceIDFunction = IoTDBDescriptor.getInstance().getConfig().isEnableIDTable() && IoTDBDescriptor.getInstance().getConfig().getDeviceIDTransformationMethod().equals("SHA256") ? SHA256DeviceID::new : PlainDeviceID::new;
    }

    private static class DeviceIDFactoryHolder {
        private static final DeviceIDFactory INSTANCE = new DeviceIDFactory();

        private DeviceIDFactoryHolder() {
        }
    }
}

