/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.role;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.audit.AuditLogOperation;
import org.apache.iotdb.db.audit.AuditLogger;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.entity.Role;
import org.apache.iotdb.db.auth.role.IRoleAccessor;
import org.apache.iotdb.db.auth.role.IRoleManager;
import org.apache.iotdb.db.auth.role.LocalFileRoleAccessor;
import org.apache.iotdb.db.concurrent.HashLock;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.utils.AuthUtils;

public abstract class BasicRoleManager
implements IRoleManager {
    private static final boolean enableAuditLog = IoTDBDescriptor.getInstance().getConfig().isEnableAuditLog();
    private Map<String, Role> roleMap = new HashMap<String, Role>();
    private IRoleAccessor accessor;
    private HashLock lock;

    BasicRoleManager(LocalFileRoleAccessor accessor) {
        this.accessor = accessor;
        this.lock = new HashLock();
    }

    @Override
    public Role getRole(String rolename) throws AuthException {
        this.lock.readLock(rolename);
        Role role = this.roleMap.get(rolename);
        try {
            if (role == null && (role = this.accessor.loadRole(rolename)) != null) {
                this.roleMap.put(rolename, role);
            }
        }
        catch (IOException e) {
            throw new AuthException(e);
        }
        finally {
            this.lock.readUnlock(rolename);
        }
        return role;
    }

    @Override
    public boolean createRole(String roleName) throws AuthException {
        Role role;
        AuthUtils.validateRolename(roleName);
        if (enableAuditLog) {
            AuditLogger.log(String.format("the role %s is created ", roleName), AuditLogOperation.DDL);
        }
        if ((role = this.getRole(roleName)) != null) {
            return false;
        }
        this.lock.writeLock(roleName);
        try {
            role = new Role(roleName);
            this.accessor.saveRole(role);
            this.roleMap.put(roleName, role);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new AuthException(e);
        }
        finally {
            this.lock.writeUnlock(roleName);
        }
    }

    @Override
    public boolean deleteRole(String rolename) throws AuthException {
        this.lock.writeLock(rolename);
        try {
            if (this.accessor.deleteRole(rolename)) {
                this.roleMap.remove(rolename);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new AuthException(e);
        }
        finally {
            this.lock.writeUnlock(rolename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean grantPrivilegeToRole(String rolename, String path, int privilegeId) throws AuthException {
        AuthUtils.validatePrivilegeOnPath(path, privilegeId);
        this.lock.writeLock(rolename);
        try {
            Role role = this.getRole(rolename);
            if (role == null) {
                throw new AuthException(String.format("No such role %s", rolename));
            }
            if (role.hasPrivilege(path, privilegeId)) {
                boolean bl = false;
                return bl;
            }
            HashSet<Integer> privilegesCopy = new HashSet<Integer>(role.getPrivileges(path));
            role.addPrivilege(path, privilegeId);
            try {
                this.accessor.saveRole(role);
            }
            catch (IOException e) {
                role.setPrivileges(path, privilegesCopy);
                throw new AuthException(e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(rolename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokePrivilegeFromRole(String rolename, String path, int privilegeId) throws AuthException {
        AuthUtils.validatePrivilegeOnPath(path, privilegeId);
        this.lock.writeLock(rolename);
        try {
            Role role = this.getRole(rolename);
            if (role == null) {
                throw new AuthException(String.format("No such role %s", rolename));
            }
            if (!role.hasPrivilege(path, privilegeId)) {
                boolean bl = false;
                return bl;
            }
            role.removePrivilege(path, privilegeId);
            try {
                this.accessor.saveRole(role);
            }
            catch (IOException e) {
                role.addPrivilege(path, privilegeId);
                throw new AuthException(e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(rolename);
        }
    }

    @Override
    public void reset() {
        this.accessor.reset();
        this.roleMap.clear();
    }

    @Override
    public List<String> listAllRoles() {
        List<String> rtlist = this.accessor.listAllRoles();
        rtlist.sort(null);
        return rtlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAllRoles(Map<String, Role> roles) throws AuthException {
        BasicRoleManager basicRoleManager = this;
        synchronized (basicRoleManager) {
            this.reset();
            this.roleMap = roles;
            for (Map.Entry<String, Role> entry : this.roleMap.entrySet()) {
                Role role = entry.getValue();
                try {
                    this.accessor.saveRole(role);
                }
                catch (IOException e) {
                    throw new AuthException(e);
                }
            }
        }
    }
}

