/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.exp.func;

import java.util.function.Supplier;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.exp.ExpressionFactory;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlScalar;
import org.apache.ignite3.internal.sql.engine.exec.exp.func.SystemRangeTableFunction;
import org.apache.ignite3.internal.sql.engine.exec.exp.func.TableFunction;
import org.apache.ignite3.internal.sql.engine.exec.exp.func.TableFunctionRegistry;
import org.apache.ignite3.internal.sql.engine.sql.fun.IgniteSqlOperatorTable;
import org.jetbrains.annotations.Nullable;

public class TableFunctionRegistryImpl
implements TableFunctionRegistry {
    @Override
    public <RowT> TableFunction<RowT> getTableFunction(ExecutionContext<RowT> ctx, RexCall rexCall) {
        if (rexCall.getOperator() == IgniteSqlOperatorTable.SYSTEM_RANGE) {
            Supplier<Long> start = TableFunctionRegistryImpl.implementGetLongExpr(ctx, ctx.expressionFactory(), (RexNode)rexCall.operands.get(0));
            Supplier<Long> end = TableFunctionRegistryImpl.implementGetLongExpr(ctx, ctx.expressionFactory(), (RexNode)rexCall.operands.get(1));
            Supplier<Long> increment = rexCall.operands.size() > 2 ? TableFunctionRegistryImpl.implementGetLongExpr(ctx, ctx.expressionFactory(), (RexNode)rexCall.operands.get(2)) : null;
            return new SystemRangeTableFunction(start, end, increment);
        }
        throw new IllegalArgumentException("Unsupported table function: " + rexCall.getOperator());
    }

    @Nullable
    private static <RowT> Supplier<Long> implementGetLongExpr(ExecutionContext<RowT> context, ExpressionFactory<RowT> expressionFactory, RexNode expr) {
        if (expr == null) {
            return null;
        }
        SqlScalar value = expressionFactory.scalar(expr);
        return () -> {
            Number num = (Number)value.get(context);
            if (num == null) {
                return null;
            }
            return num.longValue();
        };
    }
}

