/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.decorators;

import com.jakewharton.fliptables.FlipTableConverters;
import org.apache.ignite.internal.cli.core.decorator.Decorator;
import org.apache.ignite.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite.internal.cli.sql.table.Table;
import org.apache.ignite.internal.cli.util.PlainTableRenderer;

public class TableDecorator
implements Decorator<Table, TerminalOutput> {
    private final boolean plain;

    public TableDecorator(boolean plain) {
        this.plain = plain;
    }

    @Override
    public TerminalOutput decorate(Table table) {
        if (this.plain) {
            return () -> PlainTableRenderer.render(table.header(), table.content());
        }
        return () -> FlipTableConverters.fromObjects((String[])table.header(), (Object[][])table.content());
    }
}

