/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQuerySingleResult;
import org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.internal.tostring.S;

public class JdbcQueryExecuteResult
extends Response {
    private List<JdbcQuerySingleResult> results;

    public JdbcQueryExecuteResult() {
    }

    public JdbcQueryExecuteResult(int status, String err) {
        super(status, err);
    }

    public JdbcQueryExecuteResult(List<JdbcQuerySingleResult> results) {
        Objects.requireNonNull(results);
        this.results = results;
        this.hasResults = true;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        if (!this.hasResults) {
            return;
        }
        packer.packArrayHeader(this.results.size());
        for (JdbcQuerySingleResult result : this.results) {
            result.writeBinary(packer);
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        if (!this.hasResults) {
            return;
        }
        int size = unpacker.unpackArrayHeader();
        if (size == 0) {
            this.results = Collections.emptyList();
            return;
        }
        this.results = new ArrayList<JdbcQuerySingleResult>(size);
        for (int i = 0; i < size; ++i) {
            JdbcQuerySingleResult res = new JdbcQuerySingleResult();
            res.readBinary(unpacker);
            this.results.add(res);
        }
    }

    public List<JdbcQuerySingleResult> results() {
        return this.results;
    }

    @Override
    public String toString() {
        return S.toString(JdbcQueryExecuteResult.class, (Object)this);
    }
}

