/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.completer;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import io.micronaut.context.annotation.Bean;
import java.util.Set;
import org.apache.ignite.internal.cli.call.configuration.ClusterConfigShowCall;
import org.apache.ignite.internal.cli.call.configuration.ClusterConfigShowCallInput;
import org.apache.ignite.internal.cli.call.configuration.NodeConfigShowCall;
import org.apache.ignite.internal.cli.call.configuration.NodeConfigShowCallInput;
import org.apache.ignite.internal.cli.core.repl.completer.HoconDynamicCompleter;
import org.apache.ignite.internal.cli.core.repl.completer.LazyDynamicCompleter;
import org.apache.ignite.internal.cli.core.repl.completer.NodeUrlProvider;

@Bean
public class DynamicCompleterFactory {
    private final NodeConfigShowCall nodeConfigShowCall;
    private final ClusterConfigShowCall clusterConfigShowCall;
    private final NodeUrlProvider urlProvider;

    public DynamicCompleterFactory(NodeConfigShowCall nodeConfigShowCall, ClusterConfigShowCall clusterConfigShowCall, NodeUrlProvider urlProvider) {
        this.nodeConfigShowCall = nodeConfigShowCall;
        this.clusterConfigShowCall = clusterConfigShowCall;
        this.urlProvider = urlProvider;
    }

    public LazyDynamicCompleter nodeConfigCompleter(String activationPrefix) {
        return this.nodeConfigCompleter(Set.of(activationPrefix));
    }

    public LazyDynamicCompleter nodeConfigCompleter(Set<String> activationPrefixes) {
        return new LazyDynamicCompleter(() -> {
            try {
                Config config = ConfigFactory.parseString((String)this.nodeConfigShowCall.execute(NodeConfigShowCallInput.builder().nodeUrl(this.urlProvider.resolveUrl(new String[]{""})).build()).body().getValue());
                return new HoconDynamicCompleter(activationPrefixes, config);
            }
            catch (Exception e) {
                return new HoconDynamicCompleter(activationPrefixes, ConfigFactory.parseString((String)""));
            }
        });
    }

    public LazyDynamicCompleter clusterConfigCompleter(String activationPrefix) {
        return this.clusterConfigCompleter(Set.of(activationPrefix));
    }

    public LazyDynamicCompleter clusterConfigCompleter(Set<String> activationPrefixes) {
        return new LazyDynamicCompleter(() -> {
            try {
                Config config = ConfigFactory.parseString((String)this.clusterConfigShowCall.execute(ClusterConfigShowCallInput.builder().clusterUrl(this.urlProvider.resolveUrl(new String[]{""})).build()).body().getValue());
                return new HoconDynamicCompleter(activationPrefixes, config);
            }
            catch (Exception e) {
                return new HoconDynamicCompleter(activationPrefixes, ConfigFactory.parseString((String)""));
            }
        });
    }
}

