/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.hlc;

import java.io.Serializable;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public final class HybridTimestamp
implements Comparable<HybridTimestamp>,
Serializable {
    private static final long serialVersionUID = 2459861612869605904L;
    public static final int HYBRID_TIMESTAMP_SIZE = 12;
    public static final HybridTimestamp MAX_VALUE = new HybridTimestamp(Long.MAX_VALUE, Integer.MAX_VALUE);
    private final long physical;
    private final int logical;

    public HybridTimestamp(long physical, int logical) {
        assert (physical > 0L) : physical;
        assert (logical >= -1) : logical;
        this.physical = physical;
        this.logical = logical;
    }

    @Nullable
    public static HybridTimestamp max(HybridTimestamp ... times) {
        if (times.length == 0) {
            return null;
        }
        HybridTimestamp maxTime = times[0];
        for (int i = 1; i < times.length; ++i) {
            if (maxTime.compareTo(times[i]) >= 0) continue;
            maxTime = times[i];
        }
        return maxTime;
    }

    public long getPhysical() {
        return this.physical;
    }

    public int getLogical() {
        assert (this.logical >= 0);
        return this.logical;
    }

    public HybridTimestamp addTicks(int ticks) {
        return new HybridTimestamp(this.physical, this.logical + ticks);
    }

    public boolean equals(Object o) {
        if (!(o instanceof HybridTimestamp)) {
            return false;
        }
        return this.compareTo((HybridTimestamp)o) == 0;
    }

    @Override
    public int compareTo(HybridTimestamp other) {
        if (this.physical == other.physical) {
            return Integer.compare(this.logical, other.logical);
        }
        return Long.compare(this.physical, other.physical);
    }

    public String toString() {
        return S.toString(HybridTimestamp.class, this);
    }
}

