/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import org.apache.ignite.internal.jdbc.JdbcClientQueryCursorHandler;
import org.apache.ignite.internal.jdbc.JdbcConnection;
import org.apache.ignite.internal.jdbc.JdbcQueryExecuteResponse;
import org.apache.ignite.internal.jdbc.JdbcResultSet;
import org.apache.ignite.internal.jdbc.proto.IgniteQueryErrorCode;
import org.apache.ignite.internal.jdbc.proto.JdbcStatementType;
import org.apache.ignite.internal.jdbc.proto.event.JdbcBatchExecuteRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcBatchExecuteResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryExecuteRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryExecuteResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQuerySingleResult;
import org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;

public class JdbcStatement
implements Statement {
    private static final int DFLT_PAGE_SIZE = 1024;
    protected final JdbcConnection conn;
    private final int resHoldability;
    private final String schema;
    private volatile boolean closed;
    private int timeout;
    private int maxRows;
    private int pageSize = 1024;
    private volatile List<JdbcResultSet> resSets;
    private List<String> batch;
    private boolean closeOnCompletion;
    private int curRes;

    JdbcStatement(JdbcConnection conn, int resHoldability, String schema) {
        assert (conn != null);
        this.conn = conn;
        this.resHoldability = resHoldability;
        this.schema = schema;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.execute0(JdbcStatementType.SELECT_STATEMENT_TYPE, Objects.requireNonNull(sql), null);
        ResultSet rs = this.getResultSet();
        if (rs == null) {
            throw new SQLException("The query isn't SELECT query: " + sql, "42000");
        }
        return rs;
    }

    protected void execute0(JdbcStatementType stmtType, String sql, List<Object> args) throws SQLException {
        Response res;
        this.ensureNotClosed();
        this.closeResults();
        if (sql == null || sql.isEmpty()) {
            throw new SQLException("SQL query is empty.");
        }
        JdbcQueryExecuteRequest req = new JdbcQueryExecuteRequest(stmtType, this.schema, this.pageSize, this.maxRows, sql, args == null ? ArrayUtils.OBJECT_EMPTY_ARRAY : args.toArray());
        try {
            res = (Response)this.conn.handler().queryAsync(req).join();
        }
        catch (CompletionException e) {
            throw JdbcStatement.toSqlException(e);
        }
        catch (CancellationException e) {
            throw new SQLException("Query execution canceled.", "57014", e);
        }
        if (!res.hasResults()) {
            throw IgniteQueryErrorCode.createJdbcSqlException((String)res.err(), (int)res.status());
        }
        JdbcQueryExecuteResponse result = (JdbcQueryExecuteResponse)res;
        JdbcQueryExecuteResult executeResult = result.result();
        for (JdbcQuerySingleResult jdbcRes : executeResult.results()) {
            if (jdbcRes.hasResults()) continue;
            throw IgniteQueryErrorCode.createJdbcSqlException((String)jdbcRes.err(), (int)jdbcRes.status());
        }
        this.resSets = new ArrayList<JdbcResultSet>(executeResult.results().size());
        JdbcClientQueryCursorHandler handler = new JdbcClientQueryCursorHandler(result.getChannel());
        for (JdbcQuerySingleResult jdbcRes : executeResult.results()) {
            this.resSets.add(new JdbcResultSet(handler, this, jdbcRes.cursorId(), this.pageSize, jdbcRes.last(), jdbcRes.items(), jdbcRes.isQuery(), false, jdbcRes.updateCount(), this.closeOnCompletion));
        }
        assert (!this.resSets.isEmpty()) : "At least one results set is expected";
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute0(JdbcStatementType.UPDATE_STATEMENT_TYPE, Objects.requireNonNull(sql), null);
        int res = this.getUpdateCount();
        if (res == -1) {
            this.closeResults();
            throw new SQLException("The query is not DML statement: " + sql);
        }
        return res;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        switch (autoGeneratedKeys) {
            case 1: {
                throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
            }
            case 2: {
                return this.executeUpdate(sql);
            }
        }
        throw new SQLException("Invalid autoGeneratedKeys value");
    }

    @Override
    public int executeUpdate(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
    }

    @Override
    public int executeUpdate(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.closeResults();
            this.conn.removeStatement(this);
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.ensureNotClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.ensureNotClosed();
        if (max < 0) {
            throw new SQLException("Invalid field limit.");
        }
        throw new SQLFeatureNotSupportedException("Field size limitation is not supported.");
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.ensureNotClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.ensureNotClosed();
        if (maxRows < 0) {
            throw new SQLException("Invalid max rows value.");
        }
        this.maxRows = maxRows;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.ensureNotClosed();
        return this.timeout / 1000;
    }

    @Override
    public void setQueryTimeout(int timeout) throws SQLException {
        this.ensureNotClosed();
        if (timeout < 0) {
            throw new SQLException("Invalid timeout value.");
        }
        this.timeout(timeout * 1000 > timeout ? timeout * 1000 : Integer.MAX_VALUE);
    }

    @Override
    public void cancel() throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("Cancellation is not supported.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.ensureNotClosed();
        this.execute0(JdbcStatementType.ANY_STATEMENT_TYPE, Objects.requireNonNull(sql), null);
        return this.isQuery();
    }

    @Override
    public boolean execute(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        if (colIndexes != null && colIndexes.length > 0) {
            throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
        }
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        switch (autoGeneratedKeys) {
            case 1: {
                throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
            }
            case 2: {
                return this.execute(sql);
            }
        }
        throw new SQLException("Invalid autoGeneratedKeys value.");
    }

    @Override
    public boolean execute(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        if (colNames != null && colNames.length > 0) {
            throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
        }
        return this.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.ensureNotClosed();
        if (this.resSets == null || this.curRes >= this.resSets.size()) {
            return null;
        }
        JdbcResultSet rs = this.resSets.get(this.curRes);
        if (!rs.isQuery()) {
            return null;
        }
        return rs;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.ensureNotClosed();
        if (this.resSets == null || this.curRes >= this.resSets.size()) {
            return -1;
        }
        JdbcResultSet rs = this.resSets.get(this.curRes);
        if (rs.isQuery()) {
            return -1;
        }
        return (int)rs.updatedCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int curr) throws SQLException {
        this.ensureNotClosed();
        if (this.resSets == null || this.curRes >= this.resSets.size()) {
            return false;
        }
        ++this.curRes;
        if (this.resSets != null) {
            assert (this.curRes <= this.resSets.size()) : "Invalid results state: [resultsCount=" + this.resSets.size() + ", curRes=" + this.curRes + "]";
            switch (curr) {
                case 1: {
                    if (this.curRes <= 0) break;
                    this.resSets.get(this.curRes - 1).close0();
                    break;
                }
                case 2: 
                case 3: {
                    throw new SQLFeatureNotSupportedException("Multiple open results is not supported.");
                }
                default: {
                    throw new SQLException("Invalid 'current' parameter.");
                }
            }
        }
        return this.resSets != null && this.curRes < this.resSets.size();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureNotClosed();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Only forward direction is supported.");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureNotClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.ensureNotClosed();
        if (fetchSize <= 0) {
            throw new SQLException("Fetch size must be greater than zero.");
        }
        this.pageSize = fetchSize;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureNotClosed();
        return this.pageSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.ensureNotClosed();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.ensureNotClosed();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ensureNotClosed();
        Objects.requireNonNull(sql);
        if (this.batch == null) {
            this.batch = new ArrayList<String>();
        }
        this.batch.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureNotClosed();
        this.batch = null;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureNotClosed();
        this.closeResults();
        if (CollectionUtils.nullOrEmpty(this.batch)) {
            return ArrayUtils.INT_EMPTY_ARRAY;
        }
        JdbcBatchExecuteRequest req = new JdbcBatchExecuteRequest(this.conn.getSchema(), this.batch);
        try {
            JdbcBatchExecuteResult res = (JdbcBatchExecuteResult)this.conn.handler().batchAsync(req).join();
            if (!res.hasResults()) {
                throw new BatchUpdateException(res.err(), IgniteQueryErrorCode.codeToSqlState((int)res.getErrorCode()), res.getErrorCode(), res.updateCounts());
            }
            int[] nArray = res.updateCounts();
            return nArray;
        }
        catch (CompletionException e) {
            throw JdbcStatement.toSqlException(e);
        }
        catch (CancellationException e) {
            throw new SQLException("Batch execution canceled.", "57014");
        }
        finally {
            this.batch = null;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ensureNotClosed();
        return this.conn;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.ensureNotClosed();
        return this.resHoldability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn.isClosed() || this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ensureNotClosed();
        if (poolable) {
            throw new SQLFeatureNotSupportedException("Pooling is not supported.");
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ensureNotClosed();
        this.closeOnCompletion = true;
        if (this.resSets != null) {
            for (JdbcResultSet rs : this.resSets) {
                rs.closeStatement(true);
            }
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureNotClosed();
        return this.closeOnCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(Objects.requireNonNull(iface))) {
            throw new SQLException("Statement is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcStatement.class);
    }

    protected boolean isQuery() {
        return this.resSets.get(0).isQuery();
    }

    void ensureNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed.");
        }
    }

    protected void closeResults() throws SQLException {
        if (this.resSets != null) {
            for (JdbcResultSet rs : this.resSets) {
                rs.close0();
            }
            this.resSets = null;
            this.curRes = 0;
        }
    }

    void closeIfAllResultsClosed() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        boolean allRsClosed = true;
        if (this.resSets != null) {
            for (JdbcResultSet rs : this.resSets) {
                if (rs.isClosed()) continue;
                allRsClosed = false;
            }
        }
        if (allRsClosed) {
            this.close();
        }
    }

    public final void timeout(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Condition timeout >= 0 is not satisfied.");
        }
        this.timeout = timeout;
    }

    private static SQLException toSqlException(CompletionException e) {
        return new SQLException(e);
    }
}

