/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.table.ClientRecordSerializer;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.apache.ignite.table.InvokeProcessor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientRecordView<R>
implements RecordView<R> {
    private final ClientTable tbl;
    private final ClientRecordSerializer<R> ser;

    public ClientRecordView(ClientTable tbl, Mapper<R> recMapper) {
        this.tbl = tbl;
        this.ser = new ClientRecordSerializer<R>(tbl.tableId(), recMapper);
    }

    public R get(@Nullable Transaction tx, @NotNull R keyRec) {
        return ClientUtils.sync(this.getAsync(tx, keyRec));
    }

    @NotNull
    public CompletableFuture<R> getAsync(@Nullable Transaction tx, @NotNull R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(12, (s, w) -> this.ser.writeRec(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), (s, r) -> this.ser.readValRec(keyRec, (ClientSchema)s, (ClientMessageUnpacker)r), null, ClientTupleSerializer.getHashFunction(tx, this.ser.mapper(), keyRec));
    }

    public Collection<R> getAll(@Nullable Transaction tx, @NotNull Collection<R> keyRecs) {
        return ClientUtils.sync(this.getAllAsync(tx, keyRecs));
    }

    @NotNull
    public CompletableFuture<Collection<R>> getAllAsync(@Nullable Transaction tx, @NotNull Collection<R> keyRecs) {
        Objects.requireNonNull(keyRecs);
        if (keyRecs.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.tbl.doSchemaOutInOpAsync(15, (s, w) -> this.ser.writeRecs(tx, keyRecs, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), (s, r) -> this.ser.readRecs((ClientSchema)s, (ClientMessageUnpacker)r, true, TuplePart.KEY_AND_VAL), Collections.emptyList(), ClientTupleSerializer.getHashFunction(tx, this.ser.mapper(), keyRecs.iterator().next()));
    }

    public void upsert(@Nullable Transaction tx, @NotNull R rec) {
        ClientUtils.sync(this.upsertAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, @NotNull R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(10, (s, w) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), r -> null, ClientTupleSerializer.getHashFunction(tx, this.ser.mapper(), rec));
    }

    public void upsertAll(@Nullable Transaction tx, @NotNull Collection<R> recs) {
        ClientUtils.sync(this.upsertAllAsync(tx, recs));
    }

    @NotNull
    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, @NotNull Collection<R> recs) {
        Objects.requireNonNull(recs);
        if (recs.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.tbl.doSchemaOutOpAsync(13, (s, w) -> this.ser.writeRecs(tx, recs, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), r -> null, ClientTupleSerializer.getHashFunction(tx, this.ser.mapper(), recs.iterator().next()));
    }

    public R getAndUpsert(@Nullable Transaction tx, @NotNull R rec) {
        return ClientUtils.sync(this.getAndUpsertAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<R> getAndUpsertAsync(@Nullable Transaction tx, @NotNull R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(16, (s, w) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), (s, r) -> this.ser.readValRec(rec, (ClientSchema)s, (ClientMessageUnpacker)r), null, ClientTupleSerializer.getHashFunction(tx, this.ser.mapper(), rec));
    }

    public boolean insert(@Nullable Transaction tx, @NotNull R rec) {
        return ClientUtils.sync(this.insertAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, @NotNull R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(18, (s, w) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, this.ser.mapper(), rec));
    }

    public Collection<R> insertAll(@Nullable Transaction tx, @NotNull Collection<R> recs) {
        return ClientUtils.sync(this.insertAllAsync(tx, recs));
    }

    @NotNull
    public CompletableFuture<Collection<R>> insertAllAsync(@Nullable Transaction tx, @NotNull Collection<R> recs) {
        Objects.requireNonNull(recs);
        if (recs.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.tbl.doSchemaOutInOpAsync(20, (s, w) -> this.ser.writeRecs(tx, recs, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), (s, r) -> this.ser.readRecs((ClientSchema)s, (ClientMessageUnpacker)r, false, TuplePart.KEY_AND_VAL), Collections.emptyList(), ClientTupleSerializer.getHashFunction(tx, this.ser.mapper(), recs.iterator().next()));
    }

    public boolean replace(@Nullable Transaction tx, @NotNull R rec) {
        return ClientUtils.sync(this.replaceAsync(tx, rec));
    }

    public boolean replace(@Nullable Transaction tx, @NotNull R oldRec, @NotNull R newRec) {
        return ClientUtils.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(22, (s, w) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, this.ser.mapper(), rec));
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull R oldRec, @NotNull R newRec) {
        Objects.requireNonNull(oldRec);
        Objects.requireNonNull(newRec);
        return this.tbl.doSchemaOutOpAsync(24, (s, w) -> this.ser.writeRecs(tx, oldRec, newRec, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, this.ser.mapper(), oldRec));
    }

    public R getAndReplace(@Nullable Transaction tx, @NotNull R rec) {
        return ClientUtils.sync(this.getAndReplaceAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<R> getAndReplaceAsync(@Nullable Transaction tx, @NotNull R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(26, (s, w) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), (s, r) -> this.ser.readValRec(rec, (ClientSchema)s, (ClientMessageUnpacker)r), null, ClientTupleSerializer.getHashFunction(tx, this.ser.mapper(), rec));
    }

    public boolean delete(@Nullable Transaction tx, @NotNull R keyRec) {
        return ClientUtils.sync(this.deleteAsync(tx, keyRec));
    }

    @NotNull
    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, @NotNull R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutOpAsync(28, (s, w) -> this.ser.writeRec(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, this.ser.mapper(), keyRec));
    }

    public boolean deleteExact(@Nullable Transaction tx, @NotNull R rec) {
        return ClientUtils.sync(this.deleteExactAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, @NotNull R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(30, (s, w) -> this.ser.writeRec(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, this.ser.mapper(), rec));
    }

    public R getAndDelete(@Nullable Transaction tx, @NotNull R keyRec) {
        return ClientUtils.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    @NotNull
    public CompletableFuture<R> getAndDeleteAsync(@Nullable Transaction tx, @NotNull R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(32, (s, w) -> this.ser.writeRec(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), (s, r) -> this.ser.readValRec(keyRec, (ClientSchema)s, (ClientMessageUnpacker)r), null, ClientTupleSerializer.getHashFunction(tx, this.ser.mapper(), keyRec));
    }

    public Collection<R> deleteAll(@Nullable Transaction tx, @NotNull Collection<R> keyRecs) {
        return ClientUtils.sync(this.deleteAllAsync(tx, keyRecs));
    }

    @NotNull
    public CompletableFuture<Collection<R>> deleteAllAsync(@Nullable Transaction tx, @NotNull Collection<R> keyRecs) {
        Objects.requireNonNull(keyRecs);
        if (keyRecs.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.tbl.doSchemaOutInOpAsync(29, (s, w) -> this.ser.writeRecs(tx, keyRecs, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), (s, r) -> this.ser.readRecs((ClientSchema)s, (ClientMessageUnpacker)r, false, TuplePart.KEY), Collections.emptyList(), ClientTupleSerializer.getHashFunction(tx, this.ser.mapper(), keyRecs.iterator().next()));
    }

    public Collection<R> deleteAllExact(@Nullable Transaction tx, @NotNull Collection<R> recs) {
        return ClientUtils.sync(this.deleteAllExactAsync(tx, recs));
    }

    @NotNull
    public CompletableFuture<Collection<R>> deleteAllExactAsync(@Nullable Transaction tx, @NotNull Collection<R> recs) {
        Objects.requireNonNull(recs);
        if (recs.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.tbl.doSchemaOutInOpAsync(31, (s, w) -> this.ser.writeRecs(tx, recs, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), (s, r) -> this.ser.readRecs((ClientSchema)s, (ClientMessageUnpacker)r, false, TuplePart.KEY_AND_VAL), Collections.emptyList(), ClientTupleSerializer.getHashFunction(tx, this.ser.mapper(), recs.iterator().next()));
    }

    public <T extends Serializable> T invoke(@Nullable Transaction tx, @NotNull R keyRec, InvokeProcessor<R, R, T> proc) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public <T extends Serializable> CompletableFuture<T> invokeAsync(@Nullable Transaction tx, @NotNull R keyRec, InvokeProcessor<R, R, T> proc) {
        throw new UnsupportedOperationException();
    }

    public <T extends Serializable> Map<R, T> invokeAll(@Nullable Transaction tx, @NotNull Collection<R> keyRecs, InvokeProcessor<R, R, T> proc) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public <T extends Serializable> CompletableFuture<Map<R, T>> invokeAllAsync(@Nullable Transaction tx, @NotNull Collection<R> keyRecs, InvokeProcessor<R, R, T> proc) {
        throw new UnsupportedOperationException();
    }
}

