/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.marshaller.ClientMarshallerReader;
import org.apache.ignite.internal.marshaller.ClientMarshallerWriter;
import org.apache.ignite.internal.marshaller.Marshaller;
import org.apache.ignite.internal.marshaller.MarshallerException;
import org.apache.ignite.internal.marshaller.MarshallerReader;
import org.apache.ignite.internal.marshaller.MarshallerUtil;
import org.apache.ignite.internal.marshaller.MarshallerWriter;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientRecordSerializer<R> {
    private final UUID tableId;
    private final Mapper<R> mapper;
    private final boolean oneColumnMode;

    ClientRecordSerializer(UUID tableId, Mapper<R> mapper) {
        assert (tableId != null);
        assert (mapper != null);
        this.tableId = tableId;
        this.mapper = mapper;
        this.oneColumnMode = MarshallerUtil.mode((Class)mapper.targetType()) != null;
    }

    Mapper<R> mapper() {
        return this.mapper;
    }

    public static <R> void writeRecRaw(@Nullable R rec, Mapper<R> mapper, ClientSchema schema, ClientMessagePacker out, TuplePart part) {
        ClientRecordSerializer.writeRecRaw(rec, out, schema.getMarshaller(mapper, part), ClientRecordSerializer.columnCount(schema, part));
    }

    static <R> void writeRecRaw(@Nullable R rec, ClientMessagePacker out, Marshaller marshaller, int columnCount) {
        try {
            BinaryTupleBuilder builder = new BinaryTupleBuilder(columnCount, true);
            BitSet noValueSet = new BitSet();
            ClientMarshallerWriter writer = new ClientMarshallerWriter(builder, noValueSet);
            marshaller.writeObject(rec, (MarshallerWriter)writer);
            out.packBinaryTuple(builder, noValueSet);
        }
        catch (MarshallerException e) {
            throw new IgniteException(ErrorGroups.Common.UNKNOWN_ERR, e.getMessage(), (Throwable)e);
        }
    }

    void writeRecRaw(@Nullable R rec, ClientSchema schema, ClientMessagePacker out, TuplePart part) {
        ClientRecordSerializer.writeRecRaw(rec, this.mapper, schema, out, part);
    }

    void writeRec(@Nullable Transaction tx, @Nullable R rec, ClientSchema schema, PayloadOutputChannel out, TuplePart part) {
        out.out().packUuid(this.tableId);
        ClientTable.writeTx(tx, out);
        out.out().packInt(schema.version());
        this.writeRecRaw(rec, schema, out.out(), part);
    }

    void writeRecs(@Nullable Transaction tx, @Nullable R rec, @Nullable R rec2, ClientSchema schema, PayloadOutputChannel out, TuplePart part) {
        out.out().packUuid(this.tableId);
        ClientTable.writeTx(tx, out);
        out.out().packInt(schema.version());
        Marshaller marshaller = schema.getMarshaller(this.mapper, part);
        int columnCount = ClientRecordSerializer.columnCount(schema, part);
        ClientRecordSerializer.writeRecRaw(rec, out.out(), marshaller, columnCount);
        ClientRecordSerializer.writeRecRaw(rec2, out.out(), marshaller, columnCount);
    }

    void writeRecs(@Nullable Transaction tx, @NotNull Collection<R> recs, ClientSchema schema, PayloadOutputChannel out, TuplePart part) {
        out.out().packUuid(this.tableId);
        ClientTable.writeTx(tx, out);
        out.out().packInt(schema.version());
        out.out().packInt(recs.size());
        Marshaller marshaller = schema.getMarshaller(this.mapper, part);
        int columnCount = ClientRecordSerializer.columnCount(schema, part);
        for (R rec : recs) {
            ClientRecordSerializer.writeRecRaw(rec, out.out(), marshaller, columnCount);
        }
    }

    Collection<R> readRecs(ClientSchema schema, ClientMessageUnpacker in, boolean nullable, TuplePart part) {
        int cnt = in.unpackInt();
        if (cnt == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> res = new ArrayList<Object>(cnt);
        Marshaller marshaller = schema.getMarshaller(this.mapper, part);
        try {
            for (int i = 0; i < cnt; ++i) {
                if (nullable && !in.unpackBoolean()) {
                    res.add(null);
                    continue;
                }
                BinaryTupleReader tupleReader = new BinaryTupleReader(ClientRecordSerializer.columnCount(schema, part), in.readBinaryUnsafe());
                ClientMarshallerReader reader = new ClientMarshallerReader(tupleReader);
                res.add(marshaller.readObject((MarshallerReader)reader, null));
            }
        }
        catch (MarshallerException e) {
            throw new IgniteException(ErrorGroups.Common.UNKNOWN_ERR, e.getMessage(), (Throwable)e);
        }
        return res;
    }

    R readRec(ClientSchema schema, ClientMessageUnpacker in, TuplePart part) {
        Marshaller marshaller = schema.getMarshaller(this.mapper, part);
        BinaryTupleReader tupleReader = new BinaryTupleReader(ClientRecordSerializer.columnCount(schema, part), in.readBinaryUnsafe());
        ClientMarshallerReader reader = new ClientMarshallerReader(tupleReader);
        try {
            return (R)marshaller.readObject((MarshallerReader)reader, null);
        }
        catch (MarshallerException e) {
            throw new IgniteException(ErrorGroups.Common.UNKNOWN_ERR, e.getMessage(), (Throwable)e);
        }
    }

    R readValRec(@NotNull R keyRec, ClientSchema schema, ClientMessageUnpacker in) {
        if (this.oneColumnMode) {
            return keyRec;
        }
        Marshaller keyMarshaller = schema.getMarshaller(this.mapper, TuplePart.KEY);
        Marshaller valMarshaller = schema.getMarshaller(this.mapper, TuplePart.VAL);
        BinaryTupleReader tupleReader = new BinaryTupleReader(schema.columns().length - schema.keyColumnCount(), in.readBinaryUnsafe());
        ClientMarshallerReader reader = new ClientMarshallerReader(tupleReader);
        try {
            Object res = valMarshaller.readObject((MarshallerReader)reader, null);
            keyMarshaller.copyObject(keyRec, res);
            return (R)res;
        }
        catch (MarshallerException e) {
            throw new IgniteException(ErrorGroups.Common.UNKNOWN_ERR, e.getMessage(), (Throwable)e);
        }
    }

    private static int columnCount(ClientSchema schema, TuplePart part) {
        switch (part) {
            case KEY: {
                return schema.keyColumnCount();
            }
            case VAL: {
                return schema.columns().length - schema.keyColumnCount();
            }
            case KEY_AND_VAL: {
                return schema.columns().length;
            }
        }
        throw new IllegalArgumentException();
    }
}

